package blanco.html.parser;

import java.io.File;

import junit.framework.TestCase;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;

public class BlancoHtmlParserTest extends TestCase {
    class MyHandler extends BlancoHtmlNullContentHandler {
        public void startDocument() {
            System.out.println("startDocument()");
        }

        public void endDocument() {
            System.out.println("endDocument()");
        }

        public void startElement(final String uri, final String localName,
                final String name, final Attributes atts) throws SAXException {
            System.out.println("startElement(" + name + ", " + atts.toString()
                    + ")");
        }

        public void endElement(final String uri, final String localName,
                final String name) throws SAXException {
            System.out.println("endElement(" + name + ")");
        }

        public void characters(final char[] ch, final int start,
                final int length) {
            System.out.println("characters(" + new String(ch, start, length)
                    + ")");
        }

        public void comment(final char[] ch, final int start, final int length) {
            System.out.println("comments(" + new String(ch, start, length)
                    + ")");
        }
    }

    public void testParser001() throws Exception {
        new File("tmp").mkdirs();

        // ̓f[^B
        final byte[] inputData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/test001.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);
        parser.setLexicalHandler(serializer);
        parser.setDTDHandler(serializer);

        parser.parse(inputData);
        serializer.getWriter().close();

        // o̓f[^B
        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test001.html"));

        String modifiedInputData = BlancoStringUtil.replace(new String(
                inputData, encodingParser.getEncoding()), "\r\n", "\n", true);
        modifiedInputData = BlancoStringUtil.replace(modifiedInputData, "\r",
                "\n", true);

        assertEquals(modifiedInputData, new String(outputData, encodingParser
                .getEncoding()));
    }
}
