package blanco.html.parser;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import junit.framework.TestCase;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import blanco.commons.util.BlancoFileUtil;

public class BlancoHtmlParserXmlTest extends TestCase {
    /**
     * XML Ńp[X HTML ƂăVACY鎎B
     * 
     * @throws Exception
     */
    public void testParser001() throws Exception {
        new File("tmp").mkdirs();
        InputStream inStream = null;
        try {
            final BlancoHtmlContentSerializer handler = new BlancoHtmlContentSerializer();
            handler.setWriter(new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(new File("./tmp/testXml001.html")))));

            inStream = new BufferedInputStream(new FileInputStream(
                    "./build.xml"));

            // XMLp[T̐ݒRg[̂ŁAXMLReaderD悵ėpB
            XMLReader reader = null;
            try {
                reader = XMLReaderFactory.createXMLReader();
            } catch (SAXException e) {
                // ɂĂ(JDK 1.4.2ŋH?) XMLReader̎擾Ɏsꍇ܂B

                // XMLReaderFactory.createXMLReader() ĂяoɁA
                // org.xml.sax.SAXException: System property org.xml.sax.driver
                // not specified 邱ƂmFĂ܂B
                final SAXResult result = new SAXResult(handler);
                result.setHandler(handler);
                result.setLexicalHandler(handler);
                // TODO DTDHandler
                final TransformerFactory tf = TransformerFactory.newInstance();
                try {
                    final Transformer transformer = tf.newTransformer();
                    transformer.transform(new StreamSource(inStream), result);
                    return;

                } catch (TransformerException e2) {
                    throw new IllegalArgumentException(
                            "BlancoXmlUnmarshaller: XML͗O܂B"
                                    + e2.toString());
                }
            }

            // XMLReader𖳎Ɏ擾łꍇɂ́Aʂ܂B

            try {
                // ODTDǂݍ܂Ȃ邽߂̎B
                reader
                        .setFeature(
                                "http://apache.org/xml/features/nonvalidating/load-external-dtd",
                                false);
            } catch (SAXNotRecognizedException e) {
                Logger.getLogger("blanco.xml.bind").finest(
                        "ODTDǂݍ܂Ȃݒ̎{Ɏs܂: " + e.toString());
            }

            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            // Rg邽߂ɃvpeBݒB
            reader.setProperty("http://xml.org/sax/properties/lexical-handler",
                    handler);

            // DTD 錾݂͌͏Ă܂B
            // ́Ȁ݂͈͂ javax.xml.transform.sax.TransformerHandler
            // ƌ肵Ă邽߂łB
            // reader.setProperty(
            // "http://xml.org/sax/properties/declaration-handler",
            // handler);

            reader.parse(new InputSource(inStream));
            return;

        } catch (SAXException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: XML͗O܂B" + e.toString());
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: ɓo͗O܂B" + e.toString());
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(
                            "BlancoXmlUnmarshaller: ɓo͗O܂B"
                                    + e.toString());
                }
            }
        }
    }

    /**
     * HTML Ńp[X XMLŃVACY鎎B
     * 
     * XMLŃVACYƁA Content-Type ⊮A UTF-8 ?
     * 
     * @throws Exception
     */
    public void testParser002() throws Exception {
        new File("tmp").mkdirs();
        try {
            TransformerHandler handler = null;

            final TransformerFactory tf = TransformerFactory.newInstance();
            final SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
            try {
                handler = saxTf.newTransformerHandler();

                handler.getTransformer().setOutputProperty("encoding",
                        "Windows-31J");

            } catch (TransformerConfigurationException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(
                        "BlancoXmlMarshaller: gXtH[}[nhɎs܂B"
                                + e.toString());
            }

            handler.setResult(new StreamResult(new FileOutputStream(
                    "./tmp/testXml002.html")));

            final BlancoHtmlParser parser = BlancoHtmlParserFactory
                    .getInstance();
            parser.setHandler(handler);
            parser.setLexicalHandler(handler);
            parser.setDTDHandler(handler);
            parser.parse(BlancoFileUtil.file2Bytes(new File(
                    "./test/data/test001.html")));

            return;
        } catch (SAXException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: XML͗O܂B" + e.toString());
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller: ɓo͗O܂B" + e.toString());
        }
    }
}
