/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneFilter
extends AbstractTableModel
implements Serializable {
    private String className = null;
    private boolean on = true;
    private boolean fromPlugin = false;
    private boolean sourceEncodingVariable;
    private boolean targetEncodingVariable;
    private List<Instance> instances = new ArrayList<Instance>();
    private Serializable options = null;

    public OneFilter() {
    }

    public OneFilter(AbstractFilter abstractFilter, boolean bl) {
        this.setClassName(abstractFilter.getClass().getName());
        this.setOn(true);
        this.setFromPlugin(bl);
        this.setSourceEncodingVariable(abstractFilter.isSourceEncodingVariable());
        this.setTargetEncodingVariable(abstractFilter.isTargetEncodingVariable());
        this.setInstance(abstractFilter.getDefaultInstances());
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getHumanName() {
        try {
            AbstractFilter abstractFilter = PluginUtils.instantiateFilter(this);
            return abstractFilter.getFileFormatName();
        }
        catch (Exception exception) {
            Log.log(exception);
            return this.getClassName();
        }
    }

    public void setHumanName(String string) {
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }

    public boolean isFromPlugin() {
        return this.fromPlugin;
    }

    public void setFromPlugin(boolean bl) {
        this.fromPlugin = bl;
    }

    public boolean isSourceEncodingVariable() {
        return this.sourceEncodingVariable;
    }

    public void setSourceEncodingVariable(boolean bl) {
        this.sourceEncodingVariable = bl;
    }

    public boolean isTargetEncodingVariable() {
        return this.targetEncodingVariable;
    }

    public void setTargetEncodingVariable(boolean bl) {
        this.targetEncodingVariable = bl;
    }

    public Instance[] getInstance() {
        return this.instances.toArray(new Instance[0]);
    }

    public void setInstance(Instance[] instanceArray) {
        this.instances = new ArrayList<Instance>(Arrays.asList(instanceArray));
        this.fireTableDataChanged();
    }

    public void addInstance(Instance instance) {
        this.instances.add(instance);
        this.fireTableDataChanged();
    }

    public void removeInstance(int n) {
        this.instances.remove(n);
        this.fireTableDataChanged();
    }

    public Instance getInstance(int n) {
        return this.instances.get(n);
    }

    public void setInstance(int n, Instance instance) {
        while (n >= this.instances.size()) {
            this.instances.add(null);
        }
        this.instances.set(n, instance);
        this.fireTableRowsUpdated(n, n);
    }

    public String getHint() {
        try {
            AbstractFilter abstractFilter = PluginUtils.instantiateFilter(this);
            return abstractFilter.getHint();
        }
        catch (Exception exception) {
            Log.log(exception);
            return "";
        }
    }

    public void setHint(String string) {
    }

    public Serializable getOptions() {
        return this.options;
    }

    public void setOptions(Serializable serializable) {
        this.options = serializable;
    }

    public boolean hasOptions() {
        try {
            AbstractFilter abstractFilter = PluginUtils.instantiateFilter(this);
            return abstractFilter.hasOptions();
        }
        catch (Exception exception) {
            Log.log(exception);
            return false;
        }
    }

    public void changeOptions(Dialog dialog) {
        try {
            AbstractFilter abstractFilter = PluginUtils.instantiateFilter(this);
            this.setOptions(abstractFilter.changeOptions(dialog, this.getOptions()));
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return OStrings.getString("ONEFILTER_SOURCE_FILENAME_MASK");
            }
            case 1: {
                return OStrings.getString("ONEFILTER_SOURCE_FILE_ENCODING");
            }
            case 2: {
                return OStrings.getString("ONEFILTER_TARGET_FILE_ENCODING");
            }
            case 3: {
                return OStrings.getString("ONEFILTER_TARGET_FILENAME_ENCODING");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.getInstance().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Instance instance = this.getInstance(n);
        switch (n2) {
            case 0: {
                return instance.getSourceFilenameMask();
            }
            case 1: {
                return instance.getSourceEncodingHuman();
            }
            case 2: {
                return instance.getTargetEncodingHuman();
            }
            case 3: {
                return instance.getTargetFilenamePattern();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Instance instance = this.getInstance(n);
        switch (n2) {
            case 0: {
                instance.setSourceFilenameMask(object.toString());
                break;
            }
            case 1: {
                instance.setSourceEncoding(object.toString());
                break;
            }
            case 2: {
                instance.setTargetEncoding(object.toString());
                break;
            }
            case 3: {
                instance.setTargetFilenamePattern(object.toString());
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return this.isSourceEncodingVariable();
            }
            case 2: {
                return this.isTargetEncodingVariable();
            }
        }
        return false;
    }
}

