/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.DefaultXMLDialect;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.omegat.util.Log;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLDialect
extends DefaultXMLDialect {
    private static final Pattern XHTML_PUBLIC_DTD = Pattern.compile("-//W3C//DTD XHTML.*");
    private static final Pattern PUBLIC_XHTML = Pattern.compile("-//W3C//DTD\\s+XHTML.+");
    private static final String DTD = "/org/omegat/filters3/xml/xhtml/res/xhtml2-flat.dtd";
    private Boolean translateValue = false;
    private Boolean translateButtonValue = false;
    private Pattern skipRegExpPattern;
    private HashMap<String, String> skipMetaAttributes;

    public XHTMLDialect() {
        this.defineConstraint(CONSTRAINT_PUBLIC_DOCTYPE, XHTML_PUBLIC_DTD);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        if (string != null && PUBLIC_XHTML.matcher(string).matches() && string2.endsWith(".dtd")) {
            URL uRL = XHTMLDialect.class.getResource(DTD);
            return new InputSource(uRL.toExternalForm());
        }
        return null;
    }

    public void defineDialect(XHTMLOptions xHTMLOptions) {
        String string;
        if (xHTMLOptions == null) {
            xHTMLOptions = new XHTMLOptions();
        }
        this.defineParagraphTags(new String[]{"html", "head", "title", "body", "address", "blockquote", "center", "div", "h1", "h2", "h3", "h4", "h5", "table", "th", "tr", "td", "p", "ol", "ul", "li", "dl", "dt", "dd", "form", "textarea", "fieldset", "legend", "label", "select", "option", "hr"});
        if (xHTMLOptions.getParagraphOnBr()) {
            this.defineParagraphTag("br");
        }
        this.defineShortcut("br", "br");
        this.definePreformatTags(new String[]{"textarea", "pre"});
        this.defineIntactTags(new String[]{"style", "script", "object", "embed"});
        this.defineTranslatableAttributes(new String[]{"abbr", "alt", "content", "summary", "title"});
        if (xHTMLOptions.getTranslateHref()) {
            this.defineTranslatableAttribute("href");
        }
        if (xHTMLOptions.getTranslateSrc()) {
            this.defineTranslatableTagAttribute("img", "src");
        }
        if (xHTMLOptions.getTranslateLang()) {
            this.defineTranslatableAttributes(new String[]{"lang", "xml:lang"});
        }
        if (xHTMLOptions.getTranslateHreflang()) {
            this.defineTranslatableAttribute("hreflang");
        }
        if ((this.translateValue = Boolean.valueOf(xHTMLOptions.getTranslateValue())).booleanValue() || (this.translateButtonValue = Boolean.valueOf(xHTMLOptions.getTranslateButtonValue())).booleanValue()) {
            this.defineTranslatableTagAttribute("input", "value");
        }
        if ((string = xHTMLOptions.getSkipRegExp()) != null && string.length() > 0) {
            try {
                this.skipRegExpPattern = Pattern.compile(string, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.log(patternSyntaxException);
            }
        }
        String string2 = xHTMLOptions.getSkipMeta();
        this.skipMetaAttributes = new HashMap();
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim().toUpperCase();
            this.skipMetaAttributes.put(string3, "");
        }
    }

    @Override
    public Boolean validateTranslatableTagAttribute(String string, String string2, Attributes attributes) {
        if ("INPUT".equalsIgnoreCase(string) && string2.equalsIgnoreCase("value")) {
            if (this.translateValue.booleanValue()) {
                return true;
            }
            if (this.translateButtonValue.booleanValue()) {
                for (int i = 0; i < attributes.size(); ++i) {
                    Attribute attribute = attributes.get(i);
                    if (!"type".equalsIgnoreCase(attribute.getName()) || !"button".equalsIgnoreCase(attribute.getValue()) && !"submit".equalsIgnoreCase(attribute.getValue()) && !"reset".equalsIgnoreCase(attribute.getValue())) continue;
                    return super.validateTranslatableTagAttribute(string, string2, attributes);
                }
                return false;
            }
            return super.validateTranslatableTagAttribute(string, string2, attributes);
        }
        if ("META".equalsIgnoreCase(string) && "content".equalsIgnoreCase(string2)) {
            boolean bl = false;
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = attributes.get(i);
                String string3 = attribute.getName();
                String string4 = attribute.getValue();
                if (string3 != null && string4 != null && (bl = this.checkDoSkipMetaTag(string3, string4))) break;
            }
            if (bl) {
                return false;
            }
            return super.validateTranslatableTagAttribute(string, string2, attributes);
        }
        return super.validateTranslatableTagAttribute(string, string2, attributes);
    }

    public Pattern getSkipRegExpPattern() {
        return this.skipRegExpPattern;
    }

    public HashMap<String, String> getSkipMetaAttributes() {
        return this.skipMetaAttributes;
    }

    public boolean checkDoSkipMetaTag(String string, String string2) {
        return this.skipMetaAttributes.containsKey(string.toUpperCase() + "=" + string2.toUpperCase());
    }
}

