/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omegat.core.Core;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.xml.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TMXReader
extends DefaultHandler {
    private String creationtool = null;
    public static final String CT_OMEGAT = "OmegaT";
    private String creationtoolversion = null;
    public static final String CTV_OMEGAT_1 = "1";
    public static final String CTV_OMEGAT_1_6_RC3_RC11 = "1.6";
    public static final String CTV_OMEGAT_1_6_RC12 = "1.6 RC12";
    public static final String CTV_OMEGAT_1_6_0_FINAL = "1.6.0";
    public static final String CTV_OMEGAT_1_6_1 = "1.6.1";
    public static final String CTV_OMEGAT_CURRENT = "1.6.1";
    boolean upgradeCheckComplete = false;
    boolean upgrade14X = false;
    boolean upgradeSentSeg = false;
    private String segtype;
    public static final String SEG_PARAGRAPH = "paragraph";
    public static final String SEG_SENTENCE = "sentence";
    private static final String TMX_TMX_TAG = "tmx";
    private static final String TMX_TAG_HEADER = "header";
    private static final String TMX_TAG_BODY = "body";
    private static final String TMX_TAG_TU = "tu";
    private static final String TMX_TAG_TUV = "tuv";
    private static final String TMX_TAG_SEG = "seg";
    private static final String TMX_TAG_BPT = "bpt";
    private static final String TMX_TAG_EPT = "ept";
    private static final String TMX_TAG_HI = "hi";
    private static final String TMX_TAG_IT = "it";
    private static final String TMX_TAG_PH = "ph";
    private static final String TMX_TAG_UT = "ut";
    private static final String TMX_TAG_SUB = "sub";
    private static final String TMX_TAG_PROP = "prop";
    private static final String TMX_TAG_INLINE = "inline";
    private static final String TMX_TAG_NONE = "none";
    private static final String TMX_ATTR_LANG = "lang";
    private static final String TMX_ATTR_LANG_NS = "xml:lang";
    private static final String TMX_ATTR_CREATIONTOOL = "creationtool";
    private static final String TMX_ATTR_CREATIONTOOLVERSION = "creationtoolversion";
    private static final String TMX_ATTR_SEGTYPE = "segtype";
    private static final String TMX_ATTR_SRCLANG = "srclang";
    private static final String TMX_ATTR_TYPE = "type";
    private static final String PROPERTY_VARIANT_LANGUAGES = "OmegaT:VariantLanguages";
    private String m_encoding;
    private List<String> m_srcList;
    private List<String> m_tarList;
    private Map<String, String> m_properties;
    private Set<String> m_variantLanguages;
    private Language sourceLang;
    private Language targetLang;
    private String sourceLanguage;
    private String targetLanguage;
    private String tmxSourceLanguage;
    private boolean includeLevel2;
    private boolean isProjectTMX;
    private boolean headerParsed;
    private boolean inHeader;
    private boolean inProperty;
    private boolean inTU;
    private boolean inTUV;
    private boolean inSegment;
    private boolean sourceNotFound;
    private List<TUV> tuvs;
    private Stack<String> currentElement;
    private Stack<StringBuffer> currentSub;
    private String currentProperty;
    private boolean isSegmentingEnabled;

    public TMXReader(String string, Language language, Language language2, boolean bl) {
        this.m_encoding = string;
        this.m_srcList = new ArrayList<String>();
        this.m_tarList = new ArrayList<String>();
        this.m_properties = new HashMap<String, String>();
        this.m_variantLanguages = new HashSet<String>();
        this.sourceLang = language;
        this.targetLang = language2;
        this.sourceLanguage = language.getLanguage();
        this.targetLanguage = language2.getLanguage();
        this.isSegmentingEnabled = bl;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public int numSegments() {
        return this.m_srcList.size();
    }

    public String getSourceSegment(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return new String();
        }
        return this.m_srcList.get(n);
    }

    public String getTargetSegment(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return new String();
        }
        return this.m_tarList.get(n);
    }

    public String getCreationTool() {
        return this.creationtool;
    }

    public String getCreationToolVersion() {
        return this.creationtoolversion;
    }

    public String getProperty(String string) {
        return this.m_properties.get(string);
    }

    private void checkForUpgrades() {
        if (!this.upgradeCheckComplete) {
            if (this.getCreationTool() == null || this.getCreationToolVersion() == null) {
                return;
            }
            if (CT_OMEGAT.equals(this.getCreationTool())) {
                this.upgrade14X = this.getCreationToolVersion().compareTo(CTV_OMEGAT_1) <= 0;
                this.upgradeSentSeg = SEG_PARAGRAPH.equals(this.getSegType()) && this.isSegmentingEnabled;
            }
            this.upgradeCheckComplete = true;
        }
    }

    private boolean isUpgradeSentSeg() {
        this.checkForUpgrades();
        return this.upgradeSentSeg;
    }

    private boolean isUpgrade14X() {
        this.checkForUpgrades();
        return this.upgrade14X;
    }

    private String upgradeSegment(String string) {
        if (this.isUpgrade14X()) {
            string = this.upgradeOldTagsNumberingAndPairs(string);
        }
        return string;
    }

    private String upgradeOldTagsNumberingAndPairs(String string) {
        if (!PatternConsts.OMEGAT_TAG.matcher(string).find()) {
            return string;
        }
        try {
            int n;
            Object object;
            boolean bl;
            StringBuffer stringBuffer = new StringBuffer(string);
            Matcher matcher = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(string);
            int n2 = matcher.start();
            int n3 = matcher.end();
            boolean bl2 = matcher.group(1).length() > 0;
            String string2 = matcher.group(2);
            int n4 = Integer.parseInt(matcher.group(3));
            boolean bl3 = bl = matcher.group(4).length() > 0;
            if (n4 == 1) {
                n4 = 0;
            }
            Tag tag = new Tag(bl2, string2, n4, bl);
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            ArrayList<Tag> arrayList2 = new ArrayList<Tag>();
            HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
            HashMap<String, Tag> hashMap2 = new HashMap<String, Tag>();
            if (bl2) {
                arrayList2.add(tag);
                hashMap2.put(string2, tag);
            } else if (!bl) {
                arrayList.add(tag);
                hashMap.put(string2, tag);
            }
            int n5 = n4;
            stringBuffer.replace(n2, n3, tag.toString());
            while (matcher.find()) {
                n2 = matcher.start();
                n3 = matcher.end();
                bl2 = matcher.group(1).length() > 0;
                string2 = matcher.group(2);
                bl = matcher.group(4).length() > 0;
                tag = new Tag(bl2, string2, n4, bl);
                if (bl2 && hashMap.containsKey(string2)) {
                    object = (Tag)hashMap.get(string2);
                    n4 = ((Tag)object).num;
                    hashMap.remove(string2);
                    arrayList.remove(object);
                } else {
                    n4 = n5 + 1;
                    if (bl2) {
                        arrayList2.add(tag);
                        hashMap2.put(string2, tag);
                    } else if (!bl) {
                        arrayList.add(tag);
                        hashMap.put(string2, tag);
                    }
                }
                if (n5 < n4) {
                    n5 = n4;
                }
                stringBuffer.replace(n2, n3, tag.toString());
            }
            object = new StringBuffer();
            for (n = arrayList2.size() - 1; n > 0; --n) {
                tag = (Tag)arrayList2.get(n);
                ((StringBuffer)object).append(tag.toStringPaired());
            }
            ((StringBuffer)object).append(stringBuffer);
            for (n = arrayList.size() - 1; n > 0; --n) {
                tag = (Tag)arrayList.get(n);
                ((StringBuffer)object).append(tag.toStringPaired());
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void storeSegment(String string, String string2) {
        string = this.upgradeSegment(string);
        string2 = this.upgradeSegment(string2);
        if (this.isUpgradeSentSeg()) {
            List<String> list = Segmenter.segment(this.sourceLang, string, null, null);
            List<String> list2 = Segmenter.segment(this.sourceLang, string2, null, null);
            int n = list.size();
            if (n == list2.size()) {
                for (int i = 0; i < n; ++i) {
                    String string3 = list.get(i);
                    String string4 = list2.get(i);
                    this.m_srcList.add(string3);
                    this.m_tarList.add(string4);
                }
            } else {
                this.m_srcList.add(string);
                this.m_tarList.add(string2);
            }
        } else {
            this.m_srcList.add(string);
            this.m_tarList.add(string2);
        }
    }

    public String getSegType() {
        return this.segtype;
    }

    private void checkLevel2() {
        this.includeLevel2 = this.creationtool.equals(CT_OMEGAT);
    }

    public void loadFile(String string, boolean bl) throws IOException {
        this.isProjectTMX = bl;
        String string2 = string.endsWith(".tmp") ? string.substring(0, string.length() - 4) : string;
        try {
            Log.logRB("TMXR_INFO_READING_FILE", string2);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.getXMLReader().setEntityResolver(this);
            InputSource inputSource = new InputSource(new XMLReader(string, this.m_encoding));
            inputSource.setSystemId("");
            sAXParser.parse(inputSource, (DefaultHandler)this);
            if (!bl && this.sourceNotFound) {
                Log.logWarningRB("TMXR_WARNING_SOURCE_NOT_FOUND", new Object[0]);
            }
            Log.logRB("TMXR_INFO_READING_COMPLETE", new Object[0]);
            Log.log("");
        }
        catch (SAXParseException sAXParseException) {
            Log.logErrorRB(sAXParseException, "TMXR_FATAL_ERROR_WHILE_PARSING", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            Core.getMainWindow().displayErrorRB(sAXParseException, "TMXR_FATAL_ERROR_WHILE_PARSING", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
        catch (Exception exception) {
            Log.logErrorRB(exception, "TMXR_EXCEPTION_WHILE_PARSING", string2, Log.getLogLocation());
            Core.getMainWindow().displayErrorRB(exception, "TMXR_EXCEPTION_WHILE_PARSING", string2, Log.getLogLocation());
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        Log.logWarningRB("TMXR_WARNING_WHILE_PARSING", String.valueOf(sAXParseException.getLineNumber()), String.valueOf(sAXParseException.getColumnNumber()));
        Log.log(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        Log.logErrorRB("TMXR_RECOVERABLE_ERROR_WHILE_PARSING", String.valueOf(sAXParseException.getLineNumber()), String.valueOf(sAXParseException.getColumnNumber()));
        Log.log(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        Log.logErrorRB("TMXR_FATAL_ERROR_WHILE_PARSING", String.valueOf(sAXParseException.getLineNumber()), String.valueOf(sAXParseException.getColumnNumber()));
        Log.log(sAXParseException);
    }

    public void startDocument() {
        this.headerParsed = false;
        this.inHeader = false;
        this.inTU = false;
        this.inTUV = false;
        this.inSegment = false;
        this.tuvs = new ArrayList<TUV>();
        this.currentElement = new Stack();
        this.currentSub = new Stack();
        this.currentElement.push(TMX_TAG_NONE);
    }

    public void endDocument() {
        this.tuvs = null;
        this.currentElement = null;
        this.currentSub = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(TMX_TAG_HEADER)) {
            this.startElementHeader(attributes);
        } else if (string3.equals(TMX_TAG_TU)) {
            this.startElementTU(attributes);
        } else if (string3.equals(TMX_TAG_TUV)) {
            this.startElementTUV(attributes);
        } else if (string3.equals(TMX_TAG_SEG)) {
            this.startElementSegment(attributes);
        } else if (string3.equals(TMX_TAG_BPT) || string3.equals(TMX_TAG_EPT) || string3.equals(TMX_TAG_HI) || string3.equals(TMX_TAG_IT) || string3.equals(TMX_TAG_PH) || string3.equals(TMX_TAG_UT)) {
            this.startElementInline(attributes);
        } else if (string3.equals(TMX_TAG_SUB)) {
            this.startElementSub(attributes);
        } else if (string3.equals(TMX_TAG_PROP)) {
            this.startElementProperty(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(TMX_TAG_HEADER)) {
            this.endElementHeader();
        } else if (string3.equals(TMX_TAG_TU)) {
            this.endElementTU();
        } else if (string3.equals(TMX_TAG_TUV)) {
            this.endElementTUV();
        } else if (string3.equals(TMX_TAG_SEG)) {
            this.endElementSegment();
        } else if (string3.equals(TMX_TAG_BPT) || string3.equals(TMX_TAG_EPT) || string3.equals(TMX_TAG_HI) || string3.equals(TMX_TAG_IT) || string3.equals(TMX_TAG_PH) || string3.equals(TMX_TAG_UT)) {
            this.endElementInline();
        } else if (string3.equals(TMX_TAG_SUB)) {
            this.endElementSub();
        } else if (string3.equals(TMX_TAG_PROP)) {
            this.endElementProperty();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inProperty || this.inSegment && (this.includeLevel2 && this.currentElement.peek().equals(TMX_TAG_INLINE) || !this.currentElement.peek().equals(TMX_TAG_INLINE))) {
            this.currentSub.peek().append(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.inProperty || this.inSegment && (this.includeLevel2 && this.currentElement.peek().equals(TMX_TAG_INLINE) || !this.currentElement.peek().equals(TMX_TAG_INLINE))) {
            this.currentSub.peek().append(cArray, n, n2);
        }
    }

    private void startElementHeader(Attributes attributes) {
        this.inHeader = true;
        this.creationtool = attributes.getValue(TMX_ATTR_CREATIONTOOL);
        this.creationtoolversion = attributes.getValue(TMX_ATTR_CREATIONTOOLVERSION);
        this.segtype = attributes.getValue(TMX_ATTR_SEGTYPE);
        this.tmxSourceLanguage = attributes.getValue(TMX_ATTR_SRCLANG);
        Log.logRB("TMXR_INFO_CREATION_TOOL", this.creationtool);
        Log.logRB("TMXR_INFO_CREATION_TOOL_VERSION", this.creationtoolversion);
        Log.logRB("TMXR_INFO_SEG_TYPE", this.segtype);
        Log.logRB("TMXR_INFO_SOURCE_LANG", this.tmxSourceLanguage);
        if (!this.tmxSourceLanguage.equalsIgnoreCase(this.sourceLanguage)) {
            Log.logWarningRB("TMXR_WARNING_INCORRECT_SOURCE_LANG", this.tmxSourceLanguage, this.sourceLanguage);
        }
        if (this.isUpgrade14X()) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_14X", new Object[0]);
        }
        if (this.isUpgradeSentSeg()) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_SENTSEG", new Object[0]);
        }
        this.checkLevel2();
    }

    private void endElementHeader() {
        this.headerParsed = true;
        this.inHeader = false;
        String string = this.getProperty(PROPERTY_VARIANT_LANGUAGES);
        if (string != null) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                String string2;
                String string3 = string2 = (n = string.indexOf(44)) > 0 ? string.substring(0, n).trim() : string.trim();
                if (string2.length() > 0) {
                    this.m_variantLanguages.add(string2.substring(0, 2).toUpperCase());
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string2.substring(0, 2).toUpperCase());
                }
                string = string.substring(n + 1);
            } while (n > 0);
            Log.logRB("TMXR_INFO_VARIANT_LANGUAGES_DISPLAYED", stringBuffer.toString());
        }
    }

    private void startElementProperty(Attributes attributes) throws SAXException {
        this.currentElement.push(TMX_TAG_PROP);
        if (!this.inHeader) {
            return;
        }
        this.currentProperty = attributes.getValue(TMX_ATTR_TYPE);
        this.currentSub.push(new StringBuffer());
        this.inProperty = true;
    }

    private void endElementProperty() {
        this.currentElement.pop();
        this.inProperty = false;
        if (!this.inHeader) {
            return;
        }
        StringBuffer stringBuffer = this.currentSub.pop();
        this.m_properties.put(this.currentProperty, stringBuffer.toString());
        this.currentProperty = null;
    }

    private void startElementTU(Attributes attributes) throws SAXException {
        this.currentElement.push(TMX_TAG_TU);
        if (!this.headerParsed) {
            throw new SAXException(OStrings.getString("TMXR_ERROR_TU_BEFORE_HEADER"));
        }
        this.inTU = true;
        this.tuvs.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void endElementTU() {
        this.currentElement.pop();
        this.inTU = false;
        TUV tUV = null;
        TUV tUV2 = null;
        TUV tUV3 = null;
        TUV tUV4 = null;
        TUV tUV5 = null;
        TUV tUV6 = null;
        TUV tUV7 = null;
        for (TUV object : this.tuvs) {
            if (tUV == null && object.language.equalsIgnoreCase(this.sourceLanguage)) {
                tUV = object;
            } else if (tUV2 == null && object.language.equalsIgnoreCase(this.targetLanguage)) {
                tUV2 = object;
            } else if (tUV3 == null && object.language.regionMatches(true, 0, this.sourceLanguage, 0, 2)) {
                tUV3 = object;
            } else if (tUV4 == null && object.language.regionMatches(true, 0, this.targetLanguage, 0, 2)) {
                tUV4 = object;
            } else if (this.isProjectTMX) {
                if (tUV5 == null && (object.language.equalsIgnoreCase(this.tmxSourceLanguage) || this.tmxSourceLanguage.equalsIgnoreCase("*all*"))) {
                    tUV5 = object;
                } else if (tUV6 == null && object.language.regionMatches(true, 0, this.tmxSourceLanguage, 0, 2)) {
                    tUV6 = object;
                }
                if (tUV7 == null && !object.language.equalsIgnoreCase(this.tmxSourceLanguage)) {
                    tUV7 = object;
                }
            }
            if (tUV == null || tUV2 == null) continue;
            break;
        }
        if (tUV == null) {
            tUV = tUV3;
        }
        if (tUV == null) {
            tUV = tUV5;
        }
        if (tUV == null) {
            tUV = tUV6;
        }
        if (tUV == null) {
            this.sourceNotFound = true;
            return;
        }
        if (tUV2 == null) {
            tUV2 = tUV4;
        }
        if (tUV2 == null) {
            tUV2 = tUV7;
        }
        if (tUV2 == null) {
            tUV2 = new TUV();
        }
        this.storeSegment(tUV.text.toString(), tUV2.text.toString());
        for (int i = 0; i < tUV.subSegments.size(); ++i) {
            void var9_15;
            String string = new String();
            if (i < tUV2.subSegments.size()) {
                String string2 = tUV2.subSegments.get(i).toString();
            }
            this.storeSegment(tUV.subSegments.get(i).toString(), (String)var9_15);
        }
        if (!this.isProjectTMX) {
            for (TUV tUV8 : this.tuvs) {
                if (tUV8 == tUV || tUV8 == tUV2 || !this.m_variantLanguages.isEmpty() && !this.m_variantLanguages.contains(tUV8.language.substring(0, 2).toUpperCase())) continue;
                this.storeSegment(tUV.text.toString(), tUV8.text.toString());
            }
        }
    }

    private void startElementTUV(Attributes attributes) {
        this.currentElement.push(TMX_TAG_TUV);
        if (!this.inTU) {
            Log.logWarningRB("TMXR_WARNING_TUV_NOT_IN_TU", new Object[0]);
            return;
        }
        String string = attributes.getValue(TMX_ATTR_LANG_NS);
        if (string == null) {
            string = attributes.getValue(TMX_ATTR_LANG);
        }
        if (string == null) {
            Log.logWarningRB("TMXR_WARNING_TUV_LANG_NOT_SPECIFIED", new Object[0]);
            return;
        }
        TUV tUV = new TUV();
        tUV.language = string;
        this.tuvs.add(tUV);
        this.inTUV = true;
        this.currentSub.clear();
    }

    private void endElementTUV() {
        this.currentElement.pop();
        this.inTUV = false;
    }

    private void startElementSegment(Attributes attributes) {
        this.currentElement.push(TMX_TAG_SEG);
        if (!this.inTUV) {
            Log.logWarningRB("TMXR_WARNING_SEG_NOT_IN_TUV", new Object[0]);
            return;
        }
        this.currentSub.push(this.tuvs.get((int)(this.tuvs.size() - 1)).text);
        this.inSegment = true;
    }

    private void endElementSegment() {
        this.currentElement.pop();
        if (!this.inTUV) {
            return;
        }
        this.currentSub.pop();
        this.inSegment = false;
    }

    private void startElementInline(Attributes attributes) {
        this.currentElement.push(TMX_TAG_INLINE);
    }

    private void endElementInline() {
        this.currentElement.pop();
    }

    private void startElementSub(Attributes attributes) {
        this.currentElement.push(TMX_TAG_SUB);
        StringBuffer stringBuffer = new StringBuffer();
        this.tuvs.get((int)(this.tuvs.size() - 1)).subSegments.add(stringBuffer);
        this.currentSub.push(stringBuffer);
    }

    private void endElementSub() throws SAXException {
        this.currentElement.pop();
        this.currentSub.pop();
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    private class TUV {
        public String language;
        public StringBuffer text = new StringBuffer();
        public ArrayList<StringBuffer> subSegments = new ArrayList();
    }

    class Tag {
        public boolean end;
        public String name;
        public int num;
        public boolean alone;

        public Tag(boolean bl, String string, int n, boolean bl2) {
            this.end = bl;
            this.name = string;
            this.num = n;
            this.alone = bl2;
        }

        public String toString() {
            return "<" + (this.end ? "/" : "") + this.name + this.num + (this.alone ? "/" : "") + ">";
        }

        public String toStringPaired() {
            if (this.alone) {
                return this.toString();
            }
            return "<" + (this.end ? "" : "/") + this.name + this.num + ">";
        }
    }
}

