/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.omegat.core.data.ProjectProperties;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLStreamReader;

public class ProjectFileStorage {
    public static ProjectProperties loadProjectProperties(File file) throws IOException, TranslationException {
        ProjectProperties projectProperties = new ProjectProperties(file);
        File file2 = new File(file, "omegat.project");
        XMLStreamReader xMLStreamReader = new XMLStreamReader();
        xMLStreamReader.killEmptyBlocks();
        xMLStreamReader.setStream(file2.getAbsolutePath(), "UTF-8");
        if (xMLStreamReader.advanceToTag("omegat") == null) {
            return projectProperties;
        }
        XMLBlock xMLBlock = xMLStreamReader.advanceToTag("project");
        if (xMLBlock == null) {
            return projectProperties;
        }
        String string = xMLBlock.getAttribute("version");
        if (string != null && !string.equals("1.0")) {
            throw new TranslationException(StaticUtils.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), string));
        }
        String string2 = file2.getParentFile().getAbsolutePath() + File.separator;
        List<XMLBlock> list = xMLStreamReader.closeBlock(xMLBlock);
        if (list == null) {
            return projectProperties;
        }
        for (int i = 0; i < list.size(); ++i) {
            xMLBlock = list.get(i);
            if (xMLBlock.isClose()) continue;
            if (xMLBlock.getTagName().equals("target_dir")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                projectProperties.setTargetRoot(ProjectFileStorage.computeAbsolutePath(string2, xMLBlock.getText(), "target"));
                continue;
            }
            if (xMLBlock.getTagName().equals("source_dir")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                projectProperties.setSourceRoot(ProjectFileStorage.computeAbsolutePath(string2, xMLBlock.getText(), "source"));
                continue;
            }
            if (xMLBlock.getTagName().equals("tm_dir")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                projectProperties.setTMRoot(ProjectFileStorage.computeAbsolutePath(string2, xMLBlock.getText(), "tm"));
                continue;
            }
            if (xMLBlock.getTagName().equals("glossary_dir")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                projectProperties.setGlossaryRoot(ProjectFileStorage.computeAbsolutePath(string2, xMLBlock.getText(), "glossary"));
                continue;
            }
            if (xMLBlock.getTagName().equals("source_lang")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                if (xMLBlock == null) continue;
                projectProperties.setSourceLanguage(xMLBlock.getText());
                continue;
            }
            if (xMLBlock.getTagName().equals("target_lang")) {
                if (++i >= list.size()) break;
                xMLBlock = list.get(i);
                if (xMLBlock == null) continue;
                projectProperties.setTargetLanguage(xMLBlock.getText());
                continue;
            }
            if (!xMLBlock.getTagName().equals("sentence_seg")) continue;
            if (++i >= list.size()) break;
            xMLBlock = list.get(i);
            if (xMLBlock == null) continue;
            projectProperties.setSentenceSegmentingEnabled(Boolean.parseBoolean(xMLBlock.getText()));
        }
        return projectProperties;
    }

    public static void writeProjectFile(ProjectProperties projectProperties) throws IOException {
        File file = new File(projectProperties.getProjectRoot(), "omegat.project");
        String string = file.getParentFile().getAbsolutePath() + File.separator;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        bufferedWriter.write("<omegat>\n");
        bufferedWriter.write("  <project version=\"1.0\">\n");
        bufferedWriter.write("    <source_dir>" + ProjectFileStorage.computeRelativePath(string, projectProperties.getSourceRoot(), "source") + "</source_dir>\n");
        bufferedWriter.write("    <target_dir>" + ProjectFileStorage.computeRelativePath(string, projectProperties.getTargetRoot(), "target") + "</target_dir>\n");
        bufferedWriter.write("    <tm_dir>" + ProjectFileStorage.computeRelativePath(string, projectProperties.getTMRoot(), "tm") + "</tm_dir>\n");
        bufferedWriter.write("    <glossary_dir>" + ProjectFileStorage.computeRelativePath(string, projectProperties.getGlossaryRoot(), "glossary") + "</glossary_dir>\n");
        bufferedWriter.write("    <source_lang>" + projectProperties.getSourceLanguage() + "</source_lang>\n");
        bufferedWriter.write("    <target_lang>" + projectProperties.getTargetLanguage() + "</target_lang>\n");
        bufferedWriter.write("    <sentence_seg>" + projectProperties.isSentenceSegmentingEnabled() + "</sentence_seg>\n");
        bufferedWriter.write("  </project>\n");
        bufferedWriter.write("</omegat>\n");
        bufferedWriter.close();
    }

    private static String computeAbsolutePath(String string, String string2, String string3) {
        if ("__DEFAULT__".equals(string2)) {
            return string + string3 + File.separator;
        }
        try {
            boolean bl = false;
            for (File file : File.listRoots()) {
                try {
                    bl = string2.startsWith(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) continue;
                return new File(string2).getCanonicalPath() + File.separator;
            }
            return new File(string, string2).getCanonicalPath() + File.separator;
        }
        catch (IOException iOException) {
            return string2;
        }
    }

    private static String computeRelativePath(String string, String string2, String string3) {
        if (string2.equals(string + string3 + File.separator)) {
            return "__DEFAULT__";
        }
        try {
            String string4 = string2;
            File file = new File(string2).getCanonicalFile();
            File file2 = new File(string).getCanonicalFile();
            String string5 = new String();
            for (int i = 0; i < 2; ++i) {
                if ((file.getPath() + File.separator).startsWith(file2.getPath() + File.separator)) {
                    string4 = string5 + file.getPath().substring(file2.getPath().length());
                    if (!string4.startsWith(File.separator)) break;
                    string4 = string4.substring(1);
                    break;
                }
                file2 = file2.getParentFile();
                string5 = string5 + File.separator + "..";
            }
            return string4.replace(File.separatorChar, '/');
        }
        catch (IOException iOException) {
            return string2.replace(File.separatorChar, '/');
        }
    }
}

