/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.sql.Types;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;
import blanco.db.util.BlancoDbMappingUtilDotNet;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author tosiki iga
 */
public class PrepareCallMethod2DotNet extends BlancoDbAbstractMethod {
    public PrepareCallMethod2DotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("PrepareCall",
                "NG̃vRpC{܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getParameterList()
                .add(
                        fCgFactory.createParameter("query", "string",
                                "pNG(SQL)"));

        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List<String> listDesc = cgMethod.getLangDoc()
                .getDescriptionList();
        listDesc.add("Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B");
        listDesc
                .add("SQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[댯_ɒӂŗpĂB");
        listDesc.add("Iɂ SqlCommandIuWFNgVK쐬܂B");

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            listLine.add("if (fLog.isDebugEnabled()) {");
            listLine.add("fLog.debug(\"" + cgMethod.getName()
                    + ": query = \" + query);");
            listLine.add("}");
            listLine.add("");
        }

        listLine.add("Close();");

        listLine.add("fStatement = new SqlCommand();");
        listLine.add("fStatement.Connection = fConnection;");
        listLine.add("fStatement.Transaction = fTransaction;");
        listLine.add("fStatement.CommandText = query;");

        if (fDbSetting.getStatementTimeout() >= 0) {
            listLine.add("// Xe[gg^CAEglɂăftHglZbg܂B");
            listLine.add("fStatement.CommandTimeout = "
                    + fDbSetting.getStatementTimeout() + ";");
        }

        // |Cg: fStatement.CommandType = CommandType.StoredProcedure
        // w肷Ɗ]铮ɂ͂Ȃ܂B

        for (int indexParameter = 0; indexParameter < fSqlInfo
                .getOutParameterList().size(); indexParameter++) {
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                    .getOutParameterList().get(indexParameter);

            listLine.add("");
            listLine.add("// SQLo̓p[^[" + columnStructure.getName()
                    + "]ݒ肵܂B");

            final String stmtLine = "SqlParameter sqlOutParameter"
                    + (indexParameter + 1)
                    + " = new SqlParameter(\"@"
                    + columnStructure.getName()
                    + "\", SqlDbType."
                    + BlancoDbMappingUtilDotNet
                            .getDotNetSqlDbType(columnStructure) + ");";
            listLine.add(stmtLine);
            listLine.add("sqlOutParameter" + (indexParameter + 1)
                    + ".Direction = ParameterDirection.Output;");

            if (columnStructure.getDataType() == Types.VARCHAR) {
                listLine.add("// string^͊҂TCY8000Ƃ܂B");
                listLine.add("sqlOutParameter" + (indexParameter + 1)
                        + ".Size = 8000;");
            }

            listLine.add("fStatement.Parameters.Add(sqlOutParameter"
                    + (indexParameter + 1) + ");");
        }
    }
}