/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller.odp;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class ExecuteMethodOdpDotNet extends BlancoDbAbstractMethod {
    public ExecuteMethodOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory
                .createMethod("Execute", null);
        fCgClass.getMethodList().add(cgMethod);

        // BlancoDbCgUtilDotNet.addExceptionToMethodIntegrityConstraintException(
        // fCgFactory, cgMethod, fDbSetting);
        // BlancoDbCgUtilDotNet.addExceptionToMethodDeadlockTimeoutException(
        // fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add("XgAhvV[Ws܂B");

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        listLine.add("if (fStatement == null) {");
        listLine
                .add("// SqlCommand擾̏ԂȂ̂ŁAExecuteNonQuery()sɐ旧PrepareCall()\bhĂяoĎ擾܂B");
        listLine.add("PrepareCall();");
        listLine.add("}");

        // O܂߂ēWJ܂B
        listLine.add("");
        listLine.add("try {");
        listLine.add("fStatement.ExecuteNonQuery();");
        listLine.add("} catch (OracleException ex) {");
        listLine.add("throw BlancoDbUtil.ConvertToBlancoException(ex);");
        listLine.add("}");
    }
}