/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator.odp;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class NextMethodOdpDotNet extends BlancoDbAbstractMethod {
    public NextMethodOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("Next",
                "J[\݂̈ʒu1sֈړ܂B");
        fCgClass.getMethodList().add(cgMethod);

        /*
         * VOLłꍇɂ protectedƂ܂B
         */
        if (fSqlInfo.getSingle()) {
            cgMethod.setAccess("protected");
        }

        cgMethod.setReturn(fCgFactory.createReturn("bool",
                "V݂̍sLȏꍇtrueAȏ̍sȂꍇfalseB"));

        // BlancoDbCgUtilDotNet.addExceptionToMethodDeadlockTimeoutException(
        // fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add("");
        if (fSqlInfo.getSingle()) {
            cgMethod.getLangDoc().getDescriptionList().add(
                    "VOLȂ̂ŃXR[vprotectedƂ܂B");
        }

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        listLine.add("if (fResultSet == null) {");
        listLine.add("ExecuteQuery();");
        listLine.add("}");

        listLine.add("try {");
        listLine.add("return fResultSet.Read();");
        listLine.add("} catch (OracleException ex) {");
        listLine.add("throw BlancoDbUtil.ConvertToBlancoException(ex);");
        listLine.add("}");
    }
}