/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.meta2xml.valueobject;

/**
 * BlancoMeta2Xml ̂ȂŗpValueObjectłB
 */
public class BlancoMeta2XmlStructure {
    /**
     * tB[hw肵܂BK{ڂłB
     *
     * tB[h: [name]B
     */
    private String fName;

    /**
     * pbP[Ww肵܂BK{ڂłB
     *
     * tB[h: [package]B
     */
    private String fPackage;

    /**
     * ̃o[IuWFNg̐Lڂ܂B
     *
     * tB[h: [description]B
     */
    private String fDescription;

    /**
     * t@CRgw肵܂B
     *
     * tB[h: [fileDescription]B
     * ftHg: ["̃NXblancoValueObjectɂ莩܂B"]B
     */
    private String fFileDescription = "̃NXblancoValueObjectɂ莩܂B";

    /**
     * ϊ`t@C̈ʒuw肵܂B
     *
     * tB[h: [convertDefFile]B
     */
    private String fConvertDefFile;

    /**
     * ̓t@CgqB^fBNgɗp܂B
     *
     * tB[h: [inputFileExt]B
     * ftHg: [".xls"]B
     */
    private String fInputFileExt = ".xls";

    /**
     * o̓t@CgqB^fBNgɗp܂B
     *
     * tB[h: [outputFileExt]B
     * ftHg: [".xml"]B
     */
    private String fOutputFileExt = ".xml";

    /**
     * tB[h [name] ̒lݒ肵܂B
     *
     * tB[h̐: [tB[hw肵܂BK{ڂłB]B
     *
     * @param argName tB[h[name]ɐݒ肷lB
     */
    public void setName(final String argName) {
        fName = argName;
    }

    /**
     * tB[h [name] ̒l擾܂B
     *
     * tB[h̐: [tB[hw肵܂BK{ڂłB]B
     *
     * @return tB[h[name]擾lB
     */
    public String getName() {
        return fName;
    }

    /**
     * tB[h [package] ̒lݒ肵܂B
     *
     * tB[h̐: [pbP[Ww肵܂BK{ڂłB]B
     *
     * @param argPackage tB[h[package]ɐݒ肷lB
     */
    public void setPackage(final String argPackage) {
        fPackage = argPackage;
    }

    /**
     * tB[h [package] ̒l擾܂B
     *
     * tB[h̐: [pbP[Ww肵܂BK{ڂłB]B
     *
     * @return tB[h[package]擾lB
     */
    public String getPackage() {
        return fPackage;
    }

    /**
     * tB[h [description] ̒lݒ肵܂B
     *
     * tB[h̐: [̃o[IuWFNg̐Lڂ܂B]B
     *
     * @param argDescription tB[h[description]ɐݒ肷lB
     */
    public void setDescription(final String argDescription) {
        fDescription = argDescription;
    }

    /**
     * tB[h [description] ̒l擾܂B
     *
     * tB[h̐: [̃o[IuWFNg̐Lڂ܂B]B
     *
     * @return tB[h[description]擾lB
     */
    public String getDescription() {
        return fDescription;
    }

    /**
     * tB[h [fileDescription] ̒lݒ肵܂B
     *
     * tB[h̐: [t@CRgw肵܂B]B
     *
     * @param argFileDescription tB[h[fileDescription]ɐݒ肷lB
     */
    public void setFileDescription(final String argFileDescription) {
        fFileDescription = argFileDescription;
    }

    /**
     * tB[h [fileDescription] ̒l擾܂B
     *
     * tB[h̐: [t@CRgw肵܂B]B
     * ftHg: ["̃NXblancoValueObjectɂ莩܂B"]B
     *
     * @return tB[h[fileDescription]擾lB
     */
    public String getFileDescription() {
        return fFileDescription;
    }

    /**
     * tB[h [convertDefFile] ̒lݒ肵܂B
     *
     * tB[h̐: [ϊ`t@C̈ʒuw肵܂B]B
     *
     * @param argConvertDefFile tB[h[convertDefFile]ɐݒ肷lB
     */
    public void setConvertDefFile(final String argConvertDefFile) {
        fConvertDefFile = argConvertDefFile;
    }

    /**
     * tB[h [convertDefFile] ̒l擾܂B
     *
     * tB[h̐: [ϊ`t@C̈ʒuw肵܂B]B
     *
     * @return tB[h[convertDefFile]擾lB
     */
    public String getConvertDefFile() {
        return fConvertDefFile;
    }

    /**
     * tB[h [inputFileExt] ̒lݒ肵܂B
     *
     * tB[h̐: [̓t@CgqB^fBNgɗp܂B]B
     *
     * @param argInputFileExt tB[h[inputFileExt]ɐݒ肷lB
     */
    public void setInputFileExt(final String argInputFileExt) {
        fInputFileExt = argInputFileExt;
    }

    /**
     * tB[h [inputFileExt] ̒l擾܂B
     *
     * tB[h̐: [̓t@CgqB^fBNgɗp܂B]B
     * ftHg: [".xls"]B
     *
     * @return tB[h[inputFileExt]擾lB
     */
    public String getInputFileExt() {
        return fInputFileExt;
    }

    /**
     * tB[h [outputFileExt] ̒lݒ肵܂B
     *
     * tB[h̐: [o̓t@CgqB^fBNgɗp܂B]B
     *
     * @param argOutputFileExt tB[h[outputFileExt]ɐݒ肷lB
     */
    public void setOutputFileExt(final String argOutputFileExt) {
        fOutputFileExt = argOutputFileExt;
    }

    /**
     * tB[h [outputFileExt] ̒l擾܂B
     *
     * tB[h̐: [o̓t@CgqB^fBNgɗp܂B]B
     * ftHg: [".xml"]B
     *
     * @return tB[h[outputFileExt]擾lB
     */
    public String getOutputFileExt() {
        return fOutputFileExt;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.meta2xml.valueobject.BlancoMeta2XmlStructure[");
        buf.append("name=" + fName);
        buf.append(",package=" + fPackage);
        buf.append(",description=" + fDescription);
        buf.append(",fileDescription=" + fFileDescription);
        buf.append(",convertDefFile=" + fConvertDefFile);
        buf.append(",inputFileExt=" + fInputFileExt);
        buf.append(",outputFileExt=" + fOutputFileExt);
        buf.append("]");
        return buf.toString();
    }
}
