package blanco.plugin.jsf.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.jsf.BlancoJsfConstants;
import blanco.jsf.resourcebundle.BlancoJsfResourceBundle;
import blanco.plugin.jsf.BlancoJsfPlugin;
import blanco.plugin.jsf.BlancoJsfPluginConstants;
import blanco.plugin.jsf.actions.BlancoJsfGenerateAction;

/**
 * GfB^ <br>
 * 
 * @author iga
 */
public class BlancoJsfEditor extends AbstractBlancoJsfEditor {
    private static final BlancoJsfResourceBundle fBundle = new BlancoJsfResourceBundle();

    private Composite top = null;

    // rWÄ
    private Label labelBlancoTitle = null;

    private Label labelBlancoSettingId = null;

    private Text textBlancoSettingId = null;

    // TODO ݎgpłĂȂB
    private Combo comboRuntimePackage = null;

    private Label labelMetadir = null;

    private Text textMetadir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button buttonExecuteJavaSource = null;

    private Button buttonCreateMetafile = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoTitle = new Label(top, SWT.NONE);
        labelBlancoTitle.setText(BlancoJsfConstants.PRODUCT_NAME
                + " ݒt@C GfB^ (" + BlancoJsfConstants.VERSION + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSettingId = new Label(top, SWT.NONE);
        labelBlancoSettingId.setText("ݒID");
        textBlancoSettingId = new Text(top, SWT.BORDER);
        textBlancoSettingId.setText(BlancoJsfConstants.PRODUCT_NAME);
        textBlancoSettingId.setEditable(false);

        final Label labelRuntimePackage = new Label(top, SWT.NONE);
        labelRuntimePackage.setText("^CpbP[W");
        createComboRuntimePackage();

        labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");

        textMetadir = new Text(top, SWT.BORDER);
        textMetadir.setText("meta" + BlancoJsfConstants.TARGET_SUBDIRECTORY);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile
                .setText(fBundle.getMetafileDisplayname() + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (textMetadir.getText().length() == 0) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNgw肵ĂB\n"
                                    + "^fBNg̈ʓIȐݒl 'meta"
                                    + BlancoJsfConstants.TARGET_SUBDIRECTORY
                                    + "' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoJsfPluginUtil
                                    .findFolder(input.getFile(),
                                            getProgressMonitor(),
                                            textMetadir.getText()).exists() == false) {
                                BlancoJsfPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        textMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + textMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNg쐬Ɏs܂Bf܂B:"
                                    + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        InputStream inStream = null;
                        try {
                            final URL localURL = BlancoJsfPlugin
                                    .getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", fBundle.getMetafileDisplayname()
                                    + "^fBNg[" + textMetadir.getText()
                                    + "]ɍ쐬܂B"
                                    + fBundle.getMetafileDisplayname()
                                    + "̐VKt@C͂ĂB",
                                    BlancoJsfConstants.PRODUCT_NAME
                                            + "Meta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            textMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            inStream = new FileInputStream(
                                    localURL.getPath()
                                            + BlancoJsfPluginConstants.TEMPLATE_FILENAME_WITHOUT_EXT
                                            + ".xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(textMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            MessageDialog.openInformation(top.getShell(),
                                    fBundle.getMetafileDisplayname() + " VK쐬",
                                    fBundle.getMetafileDisplayname() + " ["
                                            + newMetaFilename + "] ^fBNg["
                                            + textMetadir.getText()
                                            + "]ɐVK쐬܂B\n"
                                            + "̃t@CҏWāA֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        } finally {
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteJavaSource = new Button(top, SWT.NONE);
        buttonExecuteJavaSource.setText("\[XR[h");
        buttonExecuteJavaSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    textMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + textMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(false);

                            String runtimePackage = comboRuntimePackage
                                    .getText();
                            if (runtimePackage.trim().length() == 0) {
                                runtimePackage = null;
                            }

                            String metaDir = textMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }

                            BlancoJsfGenerateAction.processBlancoJsfSource(
                                    input.getFile(), top.getShell(),
                                    getProgressMonitor(), "java",
                                    runtimePackage, metaDir);

                            // blancotH_𓯊
                            BlancoJsfPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoJsfPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoJsfPluginUtil
                                    .refreshFolder(input.getFile(),
                                            getProgressMonitor(), textMetadir
                                                    .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl "
                + BlancoJsfPluginConstants.TARGET_FILENAME + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboRuntimePackage);
        setFocusLostHandler(textMetadir);
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (textMetadir.getText().length() == 0) {
            textMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            textMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * ^CpbP[WR{܂B
     * 
     */
    private void createComboRuntimePackage() {
        comboRuntimePackage = new Combo(top, SWT.NONE);
        comboRuntimePackage.add("myapp.jsf");
    }

    protected void loadFromTextEditorInternal(DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }
        final Element elementBlancoJsf = BlancoXmlUtil.getElement(nodeRoot,
                "blanco/target/" + BlancoJsfConstants.PRODUCT_NAME_LOWER);
        if (elementBlancoJsf == null) {
            return;
        }

        final String runtimePackage = elementBlancoJsf
                .getAttribute("runtimepackage");
        if (runtimePackage != null) {
            comboRuntimePackage.setText(runtimePackage);
        }
        final String metadir = elementBlancoJsf.getAttribute("metadir");
        if (metadir != null) {
            textMetadir.setText(metadir);
        }

    }

    /**
     * ۑs܂B
     */
    public Document saveToTextEditorInternal() {
        String runtimepackage = null;
        if (comboRuntimePackage.getText().trim().length() > 0) {
            runtimepackage = comboRuntimePackage.getText();
        }

        String metadir = null;
        if (textMetadir.getText().trim().length() > 0) {
            metadir = textMetadir.getText();
        }

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoSettingId.getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoMessage = document
                .createElement(BlancoJsfConstants.PRODUCT_NAME_LOWER);
        eleTarget.appendChild(eleBlancoMessage);

        if (runtimepackage != null) {
            eleBlancoMessage.setAttribute("runtimepackage", runtimepackage);
        }

        if (metadir != null) {
            eleBlancoMessage.setAttribute("metadir", metadir);
        }

        return document;
    }
}