/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.message.BlancoJsfMessage;
import blanco.jsf.valueobject.BlancoJsfBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfSqlItemStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uob``vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoJsfXmlParser {
    /**
     * bZ[WNXB
     */
    protected final BlancoJsfMessage fMsg = new BlancoJsfMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoJsfStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoJsfStructure[] parse(final BlancoXmlDocument argXmlDocument) {
        final List<BlancoJsfStructure> listStructure = new ArrayList<BlancoJsfStructure>();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<blanco.xml.bind.valueobject.BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");

        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final List<blanco.xml.bind.valueobject.BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSheet, "blancojsf-common");
            if (listCommon.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            // ŏ̃ACêݏĂ܂B
            final BlancoXmlElement elementCommon = listCommon.get(0);
            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            final BlancoJsfStructure processStructure = parseElementSheet(
                    elementSheet, elementCommon);
            if (processStructure != null) {
                // ꂽL܂B
                listStructure.add(processStructure);
            }
        }

        final BlancoJsfStructure[] result = new BlancoJsfStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoJsfStructure parseElementSheet(
            final BlancoXmlElement argElementSheet,
            final BlancoXmlElement argElementCommon) {
        final BlancoJsfStructure processStructure = new BlancoJsfStructure();
        // ̓p[^擾܂B

        // V[gڍׂȏ擾܂B
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fMsg
                    .getMbjfi001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "forward") != null) {
            processStructure.setForward("true".equals(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "forward")));
        }

        final BlancoXmlElement elementBeanList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancojsf-bean-list");

        if (elementBeanList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                .getElementsByTagName(elementBeanList, "bean");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final BlancoXmlElement elementField = listField.get(indexField);

            final BlancoJsfBeanItemStructure inputItem = new BlancoJsfBeanItemStructure();

            inputItem.setName(BlancoXmlBindingUtil.getTextContent(elementField,
                    "name"));
            if (BlancoStringUtil.null2Blank(inputItem.getName()).length() == 0) {
                continue;
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "type"))
                    .length() > 0) {
                String type = BlancoXmlBindingUtil.getTextContent(elementField,
                        "type");
                if (type.equals("i")) {
                    inputItem.setType(1);
                } else if (type.equals("o")) {
                    inputItem.setType(2);
                } else if (type.equals("io")) {
                    inputItem.setType(3);
                }
            }

            processStructure.getBeanList().add(inputItem);
        }

        final BlancoXmlElement elementSqlList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancojsf-sql-list");

        if (elementSqlList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listSqlField = BlancoXmlBindingUtil
                .getElementsByTagName(elementSqlList, "sql");
        for (int indexField = 0; indexField < listSqlField.size(); indexField++) {
            final BlancoXmlElement elementField = listSqlField.get(indexField);

            final BlancoJsfSqlItemStructure inputItem = new BlancoJsfSqlItemStructure();

            inputItem.setName(BlancoXmlBindingUtil.getTextContent(elementField,
                    "name"));
            if (BlancoStringUtil.null2Blank(inputItem.getName()).length() == 0) {
                continue;
            }

            processStructure.getSqlList().add(inputItem);
        }

        return processStructure;
    }
}
