/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sample.jsf.proxy;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import blanco.sample.jsf.BlancoJsfSample1AddLogic;
import blanco.sample.jsf.BlancoJsfSample1InitializeLogic;
import blanco.sample.jsf.BlancoJsfSample1ModifyLogic;
import blanco.sample.jsf.BlancoJsfSample1ViewLogic;
import blanco.sample.jsf.db.query.SimpleBookInsertInvoker;
import blanco.sample.jsf.db.query.SimpleBookSelectIterator;
import blanco.sample.jsf.util.BlancoJsfProxyUtil;

/**
 * JSF  Managed Bean Ǝۂ̏ƂȂvLVENXB
 *
 * <p>faces-config.xml ɂ͈ȉ̂悤ɓo^܂B</p>
 * <pre>
 * &lt;managed-bean&gt;
 * 	&lt;managed-bean-name&gt;BlancoJsfSample1Logic&lt;/managed-bean-name&gt;
 * 	&lt;managed-bean-class&gt;blanco.sample.jsf.proxy.BlancoJsfSample1LogicProxy&lt;/managed-bean-class&gt;
 * &lt;managed-bean-scope&gt;request&lt;/managed-bean-scope&gt;
 * &lt;/managed-bean&gt;
 * </pre>
 */
@SuppressWarnings("serial")
public class BlancoJsfSample1LogicProxy extends String {
    /**
     * ꂽǂB
     */
    private boolean fIsInitialized = false;

    /**
     * y[W̏ʁB
     */
    private String fOutcome = "error";

    /**
     * ʃ[hB
     *
     * @return eɂ炸A߂܂B
     */
    public String getLoad() {
        if (fIsInitialized == false) {
            fIsInitialized = true;
            initialize(null);
        } else {
            view(null);
        }

        return "";
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param event CxgB
     */
    public final void initialize(final ActionEvent event) {
        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1InitializeLogic logic = new blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl();

        try {
            logic.execute(this);
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param event CxgB
     */
    public final void view(final ActionEvent event) {
        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1ViewLogic logic = new blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl();

        try {
            logic.execute(this);
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param event CxgB
     */
    public final void add(final ActionEvent event) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // session  Managed Bean [integer] 擾܂B
        final Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");
        // session  Managed Bean [blancoJsfSample2Logic] 擾܂B
        final String argString = (String) rslvr.getValue(elc, null, "blancoJsfSample2Logic");

        final Connection conn = BlancoJsfProxyUtil.getConnection();
        boolean isLogicSuccess = false;
        final SimpleBookSelectIterator argSimpleBookSelectIterator = new SimpleBookSelectIterator(conn);
        final SimpleBookInsertInvoker argSimpleBookInsertInvoker = new SimpleBookInsertInvoker(conn);

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1AddLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1AddLogic logic = new blanco.sample.jsf.BlancoJsfSample1AddLogicImpl();

        try {
            final String outcome = logic.execute(this, argInteger, argString, argSimpleBookSelectIterator, argSimpleBookInsertInvoker, conn);

            conn.commit();
            isLogicSuccess = true;
            fOutcome = outcome;
            argSimpleBookSelectIterator.close();
            argSimpleBookInsertInvoker.close();
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (SQLException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        if (isLogicSuccess == false) {
            try {
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // RlNV̊JB
        BlancoJsfProxyUtil.releaseConnection(conn);
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param event CxgB
     */
    public final void modify(final ActionEvent event) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // session  Managed Bean [bigDecimal] 擾܂B
        final BigDecimal argBigDecimal = (BigDecimal) rslvr.getValue(elc, null, "bigDecimal");
        // session  Managed Bean [integer] 擾܂B
        final Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");

        final Connection conn = BlancoJsfProxyUtil.getConnection();
        boolean isLogicSuccess = false;
        final SimpleBookSelectIterator argSimpleBookSelectIterator = new SimpleBookSelectIterator(conn);

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1ModifyLogic logic = new blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl();

        try {
            logic.execute(this, argBigDecimal, argInteger, argSimpleBookSelectIterator, conn);

            conn.commit();
            isLogicSuccess = true;
            argSimpleBookSelectIterator.close();
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (SQLException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        if (isLogicSuccess == false) {
            try {
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // RlNV̊JB
        BlancoJsfProxyUtil.releaseConnection(conn);
    }

    /**
     * sʂ擾B
     *
     * @return ʏB
     */
    public final String outcome() {
        return fOutcome;
    }
}
