/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfProcessBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfProcessStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * (blancoJsf)̂߂̃vLVENXB
 */
class BlancoJsfExpandLogicProxy {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    private BlancoJsfProcessInput fInput = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructureList
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final BlancoJsfProcessInput input) {
        fInput = input;

        expandSourceFileInternal(structure, listJsfStructure, sqlInfoList,
                input);
    }

    public void expandSourceFileInternal(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final BlancoJsfProcessInput input) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(new File(input.getTargetdirjee())
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(structure.getPackage()
                + ".proxy", null);
        fCgSourceFile.setEncoding(input.getEncoding());
        fCgClass = fCgFactory.createClass(getClassName(structure),
                "JSF  Managed Bean Ǝۂ̏ƂȂvLVENXB");
        fCgSourceFile.getClassList().add(fCgClass);

        {
            fCgClass.getLangDoc().getDescriptionList().add(
                    "<p>faces-config.xml ɂ͈ȉ̂悤ɓo^܂B</p>");
            fCgClass.getLangDoc().getDescriptionList().add("<pre>");
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc("<managed-bean>"));
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc("\t<managed-bean-name>"
                                    + BlancoNameAdjuster.toClassName(structure
                                            .getName()) + structure.getSuffix()
                                    + "</managed-bean-name>"));
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc("\t<managed-bean-class>"
                                    + structure.getPackage() + ".proxy."
                                    + getClassName(structure)
                                    + "</managed-bean-class>"));
            fCgClass
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc("<managed-bean-scope>request</managed-bean-scope>"));
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc("</managed-bean>"));
            fCgClass.getLangDoc().getDescriptionList().add("</pre>");
        }

        if (BlancoStringUtil.null2Blank(structure.getBean()).length() > 0) {
            fCgClass.getExtendClassList().add(
                    fCgFactory.createType(structure.getBean()));
            fCgClass.getAnnotationList().add("SuppressWarnings(\"serial\")");
        }

        expandMethodGetLoad(structure);

        boolean isOutcomeExist = false;
        for (BlancoJsfProcessStructure processStructure : structure
                .getProcessList()) {

            final List<String> sqlClassNameList = BlancoJsfXml2SourceFile
                    .getSqlClassNameList(processStructure, sqlInfoList);

            expandMethodExecute(structure, processStructure, listJsfStructure,
                    sqlClassNameList);

            if (processStructure.getForward()) {
                isOutcomeExist = true;
            }
        }
        if (isOutcomeExist) {
            final BlancoCgField field = fCgFactory.createField("fOutcome",
                    "java.lang.String", "y[W̏ʁB");
            field.setDefault("\"error\"");
            fCgClass.getFieldList().add(field);

            expandMethodOutcome();
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    private void expandMethodGetLoad(final BlancoJsfStructure structure) {
        boolean isInitializeExist = false;
        boolean isViewExist = false;
        for (BlancoJsfProcessStructure processStructure : structure
                .getProcessList()) {
            if ("initialize".equals(processStructure.getType())) {
                isInitializeExist = true;
            } else if ("view".equals(processStructure.getType())) {
                isViewExist = true;
            }
        }
        if (isInitializeExist || isViewExist) {
            final BlancoCgField field = fCgFactory.createField(
                    "fIsInitialized", "boolean", "ꂽǂB");
            field.setDefault("false");
            fCgClass.getFieldList().add(field);

            final BlancoCgMethod method = fCgFactory.createMethod("getLoad",
                    "ʃ[hB");
            method.setReturn(fCgFactory.createReturn("java.lang.String",
                    "eɂ炸A߂܂B"));
            fCgClass.getMethodList().add(method);

            method.getLineList().add("if (fIsInitialized == false) {");
            method.getLineList().add("fIsInitialized = true;");
            if (isInitializeExist) {
                method.getLineList().add("initialize(null);");
            }
            method.getLineList().add("} else {");
            if (isViewExist) {
                method.getLineList().add("view(null);");
            }
            method.getLineList().add("}");
            method.getLineList().add("");
            method.getLineList().add("return \"\";");
        }
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param processStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(final BlancoJsfStructure structure,
            final BlancoJsfProcessStructure processStructure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<String> sqlClassNameList) {
        final BlancoCgMethod method = fCgFactory.createMethod(processStructure
                .getMethod(), "NXCX^Xďsۂ̃Gg|CgłB");
        fCgClass.getMethodList().add(method);
        method.setFinal(true);

        method.getParameterList().add(
                fCgFactory.createParameter("event",
                        "javax.faces.event.ActionEvent", "CxgB"));

        if (processStructure.getBeanList().size() > 0) {
            fCgSourceFile.getImportList().add("javax.el.ELContext");
            fCgSourceFile.getImportList().add("javax.el.ELResolver");
            fCgSourceFile.getImportList().add(
                    "javax.faces.context.FacesContext");

            method
                    .getLineList()
                    .add(
                            "final FacesContext ctx = FacesContext.getCurrentInstance();");
            method.getLineList().add(
                    "final ELContext elc = ctx.getELContext();");
            method
                    .getLineList()
                    .add(
                            "final ELResolver rslvr = ctx.getApplication().getELResolver();");
            method.getLineList().add("");
        }

        for (BlancoJsfProcessBeanItemStructure bean : processStructure
                .getBeanList()) {
            // Managed Bean ̒B
            // ` Beanɂ́ANXł͂Ȃ Managed Bean Ăꍇ܂B

            String managedBeanName = null;
            String managedBeanClassName = null;

            // ܂͊ǗBeanĂ̂ƉB
            final BlancoJsfStructure jsfStructure = getJsfStructureByManagedBeanName(
                    bean.getName(), listJsfStructure);
            if (jsfStructure == null) {
                // blancoJsf `ɂ͌܂łB
                // ̏ꍇ́ANX̂܂܂łB
                managedBeanName = BlancoNameAdjuster
                        .toLowerCaseTitle(BlancoNameAdjuster
                                .toClassName(BlancoNameUtil
                                        .trimJavaPackage(bean.getName())));
                managedBeanClassName = bean.getName();
            } else {
                // blancoJsf `Ɍ܂B
                managedBeanName = BlancoNameAdjuster
                        .toLowerCaseTitle(BlancoNameAdjuster
                                .toClassName(jsfStructure.getName()))
                        + jsfStructure.getSuffix();
                managedBeanClassName = jsfStructure.getBean();
            }

            method.getLineList().add(
                    "// session  Managed Bean [" + managedBeanName
                            + "] 擾܂B");
            fCgSourceFile.getImportList().add(managedBeanClassName);

            method.getLineList().add(
                    "final "
                            + BlancoNameUtil
                                    .trimJavaPackage(managedBeanClassName)
                            + " arg"
                            + BlancoNameUtil
                                    .trimJavaPackage(managedBeanClassName)
                            + " = ("
                            + BlancoNameUtil
                                    .trimJavaPackage(managedBeanClassName)
                            + ") rslvr.getValue(elc, null, \""
                            + managedBeanName + "\");");
        }
        method.getLineList().add("");

        if (processStructure.getSqlList().size() > 0) {
            addUtilImport(structure, processStructure);
            fCgSourceFile.getImportList().add("java.sql.Connection");
            method
                    .getLineList()
                    .add(
                            "final Connection conn = BlancoJsfProxyUtil.getConnection();");
            method.getLineList().add("boolean isLogicSuccess = false;");
        }

        for (String sqlClassName : sqlClassNameList) {
            fCgSourceFile.getImportList().add(sqlClassName);
            method.getLineList().add(
                    "final " + BlancoNameUtil.trimJavaPackage(sqlClassName)
                            + " arg"
                            + BlancoNameUtil.trimJavaPackage(sqlClassName)
                            + " = new "
                            + BlancoNameUtil.trimJavaPackage(sqlClassName)
                            + "(conn);");
        }
        method.getLineList().add("");

        String className = BlancoNameAdjuster.toClassName(processStructure
                .getName())
                + BlancoNameAdjuster.toClassName(processStructure.getMethod())
                + structure.getSuffix();
        fCgSourceFile.getImportList().add(
                structure.getPackage() + "." + className);
        method.getLineList().add(
                "// ȉ̃R[hŃRpCEG[ꍇɂ́ANX [" + structure.getPackage()
                        + "." + className + "Impl] VKɍ쐬ĂB");
        method.getLineList().add(
                "final " + className + " logic = new " + structure.getPackage()
                        + "." + className + "Impl();");

        {
            final StringBuffer buf = new StringBuffer();
            boolean isFirst = true;
            if (BlancoStringUtil.null2Blank(structure.getBean()).length() > 0) {
                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("this");
            }
            for (BlancoJsfProcessBeanItemStructure bean : processStructure
                    .getBeanList()) {
                String managedBeanClassName = null;

                // ܂͊ǗBeanĂ̂ƉB
                final BlancoJsfStructure jsfStructure = getJsfStructureByManagedBeanName(
                        bean.getName(), listJsfStructure);
                if (jsfStructure == null) {
                    // blancoJsf `ɂ͌܂łB
                    // ̏ꍇ́ANX̂܂܂łB
                    managedBeanClassName = bean.getName();
                } else {
                    // blancoJsf `Ɍ܂B
                    managedBeanClassName = jsfStructure.getBean();
                }

                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("arg"
                        + BlancoNameUtil.trimJavaPackage(managedBeanClassName));
            }
            for (String sql : sqlClassNameList) {
                final String classname = BlancoNameUtil.trimJavaPackage(sql);
                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("arg" + classname);
            }
            if (processStructure.getSqlList().size() > 0) {
                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("conn");
            }

            method.getLineList().add("");
            method.getLineList().add("try {");
            {
                String line = "logic.execute(" + buf.toString() + ");";
                if (processStructure.getForward()) {
                    line = "final String outcome = " + line;
                }
                method.getLineList().add(line);

                if (processStructure.getSqlList().size() > 0) {
                    method.getLineList().add("");
                }

                if (processStructure.getSqlList().size() > 0) {
                    method.getLineList().add("");
                    method.getLineList().add("conn.commit();");
                    method.getLineList().add("isLogicSuccess = true;");
                }

                if (processStructure.getForward()) {
                    method.getLineList().add("fOutcome = outcome;");
                }

                // commit  outcome ̂Ƃ closeB
                for (String sqlClassName : sqlClassNameList) {
                    method.getLineList().add(
                            "arg"
                                    + BlancoNameUtil
                                            .trimJavaPackage(sqlClassName)
                                    + ".close();");
                }
            }

            method.getLineList().add("} catch (IllegalArgumentException ex) {");
            method.getLineList().add("ex.printStackTrace();");
            method.getLineList().add("} catch (IOException ex) {");
            method.getLineList().add("ex.printStackTrace();");
            if (processStructure.getSqlList().size() > 0) {
                fCgSourceFile.getImportList().add("java.sql.SQLException");
                method.getLineList().add("} catch (SQLException ex) {");
                method.getLineList().add("ex.printStackTrace();");
            }
            fCgSourceFile.getImportList().add("java.io.IOException");
            method.getLineList().add("} catch (Exception ex) {");
            method.getLineList().add("ex.printStackTrace();");
            method.getLineList().add("}");

            if (processStructure.getSqlList().size() > 0) {
                method.getLineList().add("");
                method.getLineList().add("if (isLogicSuccess == false) {");
                method.getLineList().add("try {");
                method.getLineList().add("conn.rollback();");
                method.getLineList().add("} catch (Exception ex) {");
                method.getLineList().add("ex.printStackTrace();");
                method.getLineList().add("}");
                method.getLineList().add("}");
                method.getLineList().add("// RlNV̊JB");
                method.getLineList().add(
                        "BlancoJsfProxyUtil.releaseConnection(conn);");
            }
        }
    }

    private void expandMethodOutcome() {
        final BlancoCgMethod method = fCgFactory.createMethod("outcome",
                "sʂ擾B");
        fCgClass.getMethodList().add(method);
        method.setFinal(true);
        method.setReturn(fCgFactory.createReturn("java.lang.String", "ʏB"));
        method.getLineList().add("return fOutcome;");
    }

    private String getClassName(final BlancoJsfStructure argStructure) {
        return BlancoNameAdjuster.toClassName(argStructure.getName())
                + argStructure.getSuffix() + "Proxy";
    }

    /**
     * DB  getConnection KvȏꍇɗpB
     * 
     * @param processStructure
     */
    private void addUtilImport(final BlancoJsfStructure structure,
            final BlancoJsfProcessStructure processStructure) {
        String runtimePackage = structure.getPackage();
        if (BlancoStringUtil.null2Blank(fInput.getRuntimepackage()).length() > 0) {
            runtimePackage = fInput.getRuntimepackage();
        }

        fCgSourceFile.getImportList().add(
                runtimePackage + ".BlancoJsfProxyUtil");
    }

    /**
     * JSF\XgA^ꂽǗBeanƂɃNX擾܂B
     * 
     * @param managedBeanName
     * @param listJsfStructure
     * @return Ȃ nullB
     */
    static BlancoJsfStructure getJsfStructureByManagedBeanName(
            final String managedBeanName,
            final List<BlancoJsfStructure> listJsfStructure) {
        for (BlancoJsfStructure structureSearch : listJsfStructure) {
            if (managedBeanName.equals(BlancoNameAdjuster
                    .toLowerCaseTitle(BlancoNameAdjuster
                            .toClassName(structureSearch.getName()))
                    + structureSearch.getSuffix())) {
                // blancoJsf `瓱oł͈͂ɁAManaged Bean o^܂B
                return structureSearch;
            }
        }
        return null;
    }
}
