/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.jsf.task.valueobject.BlancoJsfProcessInput;

/**
 * Apache Ant^XN [BlancoJsf]̃NXB
 *
 * JSF`\[XR[h邽߂AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.jsf.task]BlancoJsfBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancojsf&quot; classname=&quot;blanco.jsf.task.BlancoJsfTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoJsfTask extends Task {
    /**
     * JSF`\[XR[h邽߂AntTaskłB
     */
    protected BlancoJsfProcessInput fInput = new BlancoJsfProcessInput();

    /**
     * tB[h [metadir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldMetadirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [targetdirjee] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirjeeProcessed = false;

    /**
     * tB[h [targetdirxml] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirxmlProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * tB[h [encoding] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldEncodingProcessed = false;

    /**
     * tB[h [runtimepackage] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldRuntimepackageProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
        fIsFieldMetadirProcessed = true;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[targetdirjee]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * Java EE ֘A Java \[X̏o͐tH_w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdirjee(final String arg) {
        fInput.setTargetdirjee(arg);
        fIsFieldTargetdirjeeProcessed = true;
    }

    /**
     * Ant^XN[targetdirjee]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * Java EE ֘A Java \[X̏o͐tH_w肵܂B<br>
     * ftHgl[blanco.jee]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdirjee() {
        return fInput.getTargetdirjee();
    }

    /**
     * Ant^XN[targetdirxml]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * XML o͐tH_w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdirxml(final String arg) {
        fInput.setTargetdirxml(arg);
        fIsFieldTargetdirxmlProcessed = true;
    }

    /**
     * Ant^XN[targetdirxml]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * XML o͐tH_w肵܂B<br>
     * ftHgl[blanco.xml]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdirxml() {
        return fInput.getTargetdirxml();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[encoding]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 6<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setEncoding(final String arg) {
        fInput.setEncoding(arg);
        fIsFieldEncodingProcessed = true;
    }

    /**
     * Ant^XN[encoding]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 6<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getEncoding() {
        return fInput.getEncoding();
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 7<br>
     * ^CNX𐶐鐶w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setRuntimepackage(final String arg) {
        fInput.setRuntimepackage(arg);
        fIsFieldRuntimepackageProcessed = true;
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 7<br>
     * ^CNX𐶐鐶w肵܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getRuntimepackage() {
        return fInput.getRuntimepackage();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoJsfTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldMetadirProcessed == false) {
            throw new BuildException("K{Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- targetdirjee:[" + getTargetdirjee() + "]");
            System.out.println("- targetdirxml:[" + getTargetdirxml() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- encoding:[" + getEncoding() + "]");
            System.out.println("- runtimepackage:[" + getRuntimepackage() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoJsfProcessC^tF[X blanco.jsf.taskpbP[W BlancoJsfProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoJsfProcess proc = new BlancoJsfProcessImpl();
            if (proc.execute(fInput) != BlancoJsfBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
