/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.TransformerException;

import blanco.jsf.BlancoJsfConstants;
import blanco.jsf.BlancoJsfMeta2Xml;
import blanco.jsf.BlancoJsfXml2ConfigFile;
import blanco.jsf.BlancoJsfXml2SourceFile;
import blanco.jsf.message.BlancoJsfMessage;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * ob`̎ۂ̏eB
 */
public class BlancoJsfProcessImpl implements BlancoJsfProcess {
    /**
     * bZ[WNXB
     */
    protected final BlancoJsfMessage fMsg = new BlancoJsfMessage();

    protected BlancoJsfProcessInput fInput;

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBȈꍇɂ́ABlancoJsfJsf.END_SUCCESSB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(final BlancoJsfProcessInput input) throws IOException,
            IllegalArgumentException {
        fInput = input;
        System.out.println("- " + BlancoJsfConstants.PRODUCT_NAME + " ("
                + BlancoJsfConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbjfa001(input
                        .getMetadir()));
            }

            final List<BlancoJsfStructure> structureList = new ArrayList<BlancoJsfStructure>();

            // e|fBNg쐬B
            new File(input.getTmpdir() + BlancoJsfConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoJsfMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoJsfConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoJsfConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                if (progress("Processing [" + fileMeta2[index].getName()
                        + "] ...")) {
                    return BlancoJsfBatchProcess.END_ERROR;
                }

                final BlancoJsfXml2SourceFile xml2source = new BlancoJsfXml2SourceFile();
                structureList.addAll(xml2source.parse(fileMeta2[index], input));
            }

            for (BlancoJsfStructure structure : structureList) {
                new BlancoJsfXml2SourceFile().process(structure, structureList,
                        input);
            }

            new BlancoJsfXml2ConfigFile().structure2Xml(structureList, input);

            return BlancoJsfBatchProcess.END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }

    /**
     * ̒ŃACe邽тɐi񍐂ƂăR[obN܂B
     * 
     * @param argProgressMessage
     *            ݏĂACeɊւ郁bZ[WB
     * @return ̂܂܌pꍇ falseBfNGXgꍇ trueB
     */
    public boolean progress(final String argProgressMessage) {
        if (fInput.getVerbose()) {
            System.out.println(" " + argProgressMessage);
        }
        return false;
    }
}
