/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sample.jsf.proxy;

import java.io.IOException;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import blanco.sample.jsf.BlancoJsfSample2ModifyLogic;
import blanco.sample.jsf.util.BlancoJsfProxyUtil;

/**
 * JSF  Managed Bean Ǝۂ̏ƂȂvLVENXB
 *
 * <p>faces-config.xml ɂ͈ȉ̂悤ɓo^܂B</p>
 * <pre>
 * &lt;managed-bean&gt;
 * 	&lt;managed-bean-name&gt;BlancoJsfSample2Logic&lt;/managed-bean-name&gt;
 * 	&lt;managed-bean-class&gt;blanco.sample.jsf.proxy.BlancoJsfSample2LogicProxy&lt;/managed-bean-class&gt;
 * &lt;managed-bean-scope&gt;request&lt;/managed-bean-scope&gt;
 * &lt;/managed-bean&gt;
 * </pre>
 */
@SuppressWarnings("serial")
public class BlancoJsfSample2LogicProxy extends String {
    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param actionEvent CxgB
     */
    public final void modify(final ActionEvent actionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // session  Managed Bean [integer] 擾܂B
        final Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample2ModifyLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample2ModifyLogic logic = new blanco.sample.jsf.BlancoJsfSample2ModifyLogicImpl();

        try {
            logic.execute(this, argInteger);
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("ID.\bh", ex);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("ID.\bh", ex);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("ID.\bh", ex);
        }
    }
}
