/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * (blancoJsf)̂߂̃vLVENXB
 */
class BlancoJsfExpandException {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    private BlancoJsfProcessInput fInput = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructureList
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final BlancoJsfProcessInput input) {
        fInput = input;

        expandSourceFileInternal(structure, listJsfStructure, sqlInfoList,
                input);
    }

    public void expandSourceFileInternal(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final BlancoJsfProcessInput input) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(new File(input.getTargetdirjee())
                .getAbsolutePath()
                + "/main");

        String runtimePackage = structure.getPackage();
        if (BlancoStringUtil.null2Blank(fInput.getRuntimepackage()).length() > 0) {
            runtimePackage = fInput.getRuntimepackage();
        }

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(runtimePackage, null);
        fCgSourceFile.setEncoding(input.getEncoding());
        fCgClass = fCgFactory.createClass("BlancoJsfLogicException",
                "WbNONXB");
        fCgSourceFile.getClassList().add(fCgClass);
        fCgClass.getExtendClassList().add(
                fCgFactory.createType("java.lang.Exception"));
        fCgClass.getAnnotationList().add("SuppressWarnings(\"serial\")");

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
