/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import junit.framework.TestCase;
import blanco.pdf.page.BlancoPdfPageUtil;
import blanco.pdf.page.BlancoPdfPageWriter;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.report.task.BlancoPdfReportProcessImpl;
import blanco.pdf.report.task.valueobject.BlancoPdfReportProcessInput;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfReportTest extends TestCase {
    public void testReport() throws Exception {
        final BlancoPdfSetting pdfSetting = new BlancoPdfSetting();
        pdfSetting.setConfPath("./test/conf/pdf");

        new File("./tmp/pdf").mkdirs();
        final File file = new File("./tmp/pdf/report.pdf");
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream(file));

        final BlancoPdfPageDef pageDef = BlancoPdfPageUtil.read(pdfSetting,
                "yoko01");
        final BlancoPdfPageWriter report = new BlancoPdfPageWriter(
                "./test/conf/pdf", pageDef, outStream);
        report.close();

        outStream.flush();
        outStream.close();
    }

    public void testBBB() throws Exception {
        final BlancoPdfReportProcessInput input = new BlancoPdfReportProcessInput();
        input.setConfdir("./test/conf/pdf");
        input.setVerbose(true);
        new BlancoPdfReportProcessImpl().execute(input);
    }
}
