/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.sample;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.Yoko01PdfReport;
import blanco.sample.pdf.report.items.Yoko01PdfReportBlock01Items;
import blanco.sample.pdf.report.items.Yoko01PdfReportItems;

/**
 * ꂽ\[XR[h𗘗p󎚂̗B
 */
public class BlancoPdfReportTest extends TestCase {
    List<Yoko01PdfReportItems> getItems() {
        final List<Yoko01PdfReportItems> itemsList = new ArrayList<Yoko01PdfReportItems>();

        for (int outer = 0; outer < 4; outer++) {
            for (int inner = 0; inner < 13; inner++) {
                final Yoko01PdfReportItems pdfItems = new Yoko01PdfReportItems();
                itemsList.add(pdfItems);
                {
                    pdfItems.setField00("^Cg" + outer);
                    pdfItems.setField01("Tv");
                    pdfItems.setField02(BigDecimal.valueOf(123.456));
                    pdfItems.setField04("Z^O");

                    pdfItems.setHidden01("BtB[h");
                    pdfItems.setNextpage01("ɂy[W܂B");
                    pdfItems.setNextpage02("ŏIy[WłB");
                }

                {
                    final Yoko01PdfReportBlock01Items block01 = new Yoko01PdfReportBlock01Items();
                    pdfItems.getBlock01List().add(block01);
                    block01.setAaa("BLK" + inner);
                    block01.setBbb("ubN" + inner);
                }
            }
        }

        return itemsList;
    }

    public void testReport() throws Exception {
        final long start = System.currentTimeMillis();

        new File("./tmp/pdf/").mkdirs();
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream("./tmp/pdf/aaa.pdf"));
        final BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("./conf/pdf");
        final Yoko01PdfReport report = new Yoko01PdfReport(setting, outStream);

        final List<Yoko01PdfReportItems> itemsList = getItems();

        // K(!)
        // report.normalize(itemsList);
        report.consolidatePage(itemsList);
        report.breakPageByRowCount(itemsList);
        report.processPageContinuity(itemsList);

        report.omitDitto(itemsList);
        report.applyPageNo(itemsList);

        // 󎚁B
        report.writeItemsList(itemsList);

        report.close();
        outStream.flush();
        outStream.close();

        final long end = System.currentTimeMillis();

        System.out.println(end - start + " ms");
    }
}
