/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.sample.pdf.report;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.pdf.page.BlancoPdfPageUtil;
import blanco.pdf.page.BlancoPdfPageWriter;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfMetrix;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.items.Yoko02PdfReportBlockItems;
import blanco.sample.pdf.report.items.Yoko02PdfReportItems;

import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF |[gB
 */
public class Yoko02PdfReport {
    /**
     * y[W`IuWFNgB
     */
    private BlancoPdfPageDef fPageDef;

    /**
     * y[WEC^[EIuWFNgB
     */
    private BlancoPdfPageWriter fPageWriter;

    /**
     * 1 y[W̃f[^Zbg܂B
     *
     * @param pdfSetting PDF ڌQB
     * @param outStream o̓Xg[B
     */
    public Yoko02PdfReport(final BlancoPdfSetting pdfSetting, final OutputStream outStream) {
        fPageDef = BlancoPdfPageUtil.read(pdfSetting, "yoko02");
        fPageWriter = new BlancoPdfPageWriter(pdfSetting.getConfPath(), fPageDef, outStream);
    }

    /**
     * 1 y[W̃f[^ PDF ɏo܂B
     *
     * @param pdfItems PDF ڌQB
     */
    public void writeItems(final Yoko02PdfReportItems pdfItems) {
        for (int occur = 0; occur < pdfItems.getBlockList().size(); occur++) {
            final Yoko02PdfReportBlockItems blockItems = pdfItems.getBlockList().get(occur);
            if (blockItems.getLayer() == 1) {
                final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
                metrix.setFont("gothic");
                metrix.setFontSize(20);
                if (blockItems.getBlock01() != null) {
                    fPageWriter.drawText(140.0f + 0.0f * occur, 180.0f + 60.0f * occur, blockItems.getBlock01(), metrix);
                }
            }
            if (blockItems.getLayer() == 2) {
                final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
                metrix.setFont("gothic");
                metrix.setFontSize(20);
                if (blockItems.getGokei01() != null) {
                    fPageWriter.drawText(140.0f + 0.0f * occur, 180.0f + 60.0f * occur, blockItems.getGokei01(), metrix);
                }
            }
            if (blockItems.getLayer() == 0) {
                final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
                metrix.setFont("gothic");
                metrix.setFontSize(20);
                if (blockItems.getBlock02() != null) {
                    fPageWriter.drawText(250.0f + 0.0f * occur, 180.0f + 60.0f * occur, blockItems.getBlock02(), metrix);
                }
            }
            if (blockItems.getLayer() == 0) {
                final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
                metrix.setFont("gothic");
                metrix.setFontSize(25);
                if (blockItems.getBlock03() != null) {
                    fPageWriter.drawText(290.0f + 0.0f * occur, 180.0f + 60.0f * occur, blockItems.getBlock03(), metrix);
                }
            }
            if (blockItems.getLayer() == 0) {
                final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
                metrix.setFont("gothic");
                metrix.setFontSize(20);
                if (blockItems.getBlock04() != null) {
                    fPageWriter.drawText(550.0f + 0.0f * occur, 180.0f + 60.0f * occur, blockItems.getBlock04(), metrix);
                }
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("gothic");
            metrix.setFontSize(12);
            final DecimalFormat format = new DecimalFormat();
            if (pdfItems.getPageNo() != null) {
                fPageWriter.drawText(740.0f, 30.0f, BlancoStringUtil.padLeft(format.format(pdfItems.getPageNo()), 3, ' '), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("gothic");
            metrix.setFontSize(12);
            final DecimalFormat format = new DecimalFormat();
            if (pdfItems.getTotalPageCount() != null) {
                fPageWriter.drawText(770.0f, 30.0f, format.format(pdfItems.getTotalPageCount()), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(12);
            if (pdfItems.getField00() != null) {
                fPageWriter.drawText(144.0f, 144.0f, pdfItems.getField00(), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(12);
            if (pdfItems.getField01() != null) {
                fPageWriter.drawText(72.0f, 72.0f, BlancoStringUtil.padLeft(pdfItems.getField01(), 10, ' '), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(24);
            final DecimalFormat format = new DecimalFormat("###,###.###");
            format.setMinimumFractionDigits(3);
            if (pdfItems.getField02() != null) {
                fPageWriter.drawText(144.0f, 72.0f, BlancoStringUtil.padLeft(format.format(pdfItems.getField02()), 10, ' '), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(24);
            final DecimalFormat format = new DecimalFormat("###,###.###");
            if (pdfItems.getField03() != null) {
                fPageWriter.drawText(144.0f, 72.0f, BlancoStringUtil.padLeft(format.format(pdfItems.getField03()), 10, ' '), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(24);
            if (pdfItems.getField04() != null) {
                fPageWriter.drawTextCenter(220.0f, 100.0f, pdfItems.getField04(), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(12);
            if (pdfItems.getNextpage01() != null) {
                fPageWriter.drawText(250.0f, 510.0f, pdfItems.getNextpage01(), metrix);
            }
        }
        if (pdfItems.getLayer() == 0) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(12);
            if (pdfItems.getNextpage02() != null) {
                fPageWriter.drawText(350.0f, 510.0f, pdfItems.getNextpage02(), metrix);
            }
        }
        if (pdfItems.getLayer() == -1) {
            final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
            metrix.setFont("mincho");
            metrix.setFontSize(24);
            if (pdfItems.getHidden01() != null) {
                fPageWriter.drawText(500.0f, 510.0f, pdfItems.getHidden01(), metrix);
            }
        }
    }

    /**
     * y[Wׂďo͂܂B
     *
     * @param itemsList o͂ڌQB
     */
    public void writeItemsList(final List<Yoko02PdfReportItems> itemsList) {
        boolean isFirst = true;
        for (Yoko02PdfReportItems items : itemsList) {
            if (isFirst) {
                isFirst = false;
            } else {
                nextPage();
            }
            writeItems(items);
        }
    }

    /**
     * y[W܂B
     */
    public void nextPage() {
        fPageWriter.nextPage();
    }

    /**
     * K̎{By[Wu[NȂǂ̏Ȃ܂B
     *
     * @param itemsList KڌQB
     */
    public void normalize(final List<Yoko02PdfReportItems> itemsList) {
        consolidatePage(itemsList);
        // dupRowByKey(itemsList);
        breakPageByRowCount(itemsList);
        processPageContinuity(itemsList);
        omitDitto(itemsList);

        // y[W֘A̖ߍ݁B
        applyPageNo(itemsList);
    }

    /**
     * y[W̏W񏈗Ȃ܂BׂĂ̍ڂ̒lƂɏ̂łB
     *
     * @param itemsList y[WW񂵂ڌQB
     */
    public void consolidatePage(final List<Yoko02PdfReportItems> itemsList) {
        Yoko02PdfReportItems prev = null;
        for (int index = 0; index < itemsList.size(); index++) {
            final Yoko02PdfReportItems next = itemsList.get(index);
            if (prev == null) {
                prev = next;
                continue;
            }

            // ڂ̒lrB
            if (canConsolidatePage(prev, next)) {
                // y[WW񂵂܂B
                prev.getBlockList().addAll(next.getBlockList());
                itemsList.remove(index);
                index--;
            } else {
                prev = next;
            }
        }
    }

    /**
     * y[WWł邩ǂ`FbNB
     *
     * @param prev rB
     * @param next rB
     * @return Wł邩ǂB
     */
    public boolean canConsolidatePage(final Yoko02PdfReportItems prev, final Yoko02PdfReportItems next) {
        if (prev.getPageNo() == null || next.getPageNo() == null) {
            if (prev.getPageNo() != next.getPageNo()) {
                return false;
            }
        } else if (prev.getPageNo().compareTo(next.getPageNo()) != 0) {
            return false;
        }

        if (prev.getTotalPageCount() == null || next.getTotalPageCount() == null) {
            if (prev.getTotalPageCount() != next.getTotalPageCount()) {
                return false;
            }
        } else if (prev.getTotalPageCount().compareTo(next.getTotalPageCount()) != 0) {
            return false;
        }

        if (prev.getField00() == null || next.getField00() == null) {
            if (prev.getField00() != next.getField00()) {
                return false;
            }
        } else if (prev.getField00().compareTo(next.getField00()) != 0) {
            return false;
        }

        if (prev.getField01() == null || next.getField01() == null) {
            if (prev.getField01() != next.getField01()) {
                return false;
            }
        } else if (prev.getField01().compareTo(next.getField01()) != 0) {
            return false;
        }

        if (prev.getField02() == null || next.getField02() == null) {
            if (prev.getField02() != next.getField02()) {
                return false;
            }
        } else if (prev.getField02().compareTo(next.getField02()) != 0) {
            return false;
        }

        if (prev.getField03() == null || next.getField03() == null) {
            if (prev.getField03() != next.getField03()) {
                return false;
            }
        } else if (prev.getField03().compareTo(next.getField03()) != 0) {
            return false;
        }

        if (prev.getField04() == null || next.getField04() == null) {
            if (prev.getField04() != next.getField04()) {
                return false;
            }
        } else if (prev.getField04().compareTo(next.getField04()) != 0) {
            return false;
        }

        if (prev.getNextpage01() == null || next.getNextpage01() == null) {
            if (prev.getNextpage01() != next.getNextpage01()) {
                return false;
            }
        } else if (prev.getNextpage01().compareTo(next.getNextpage01()) != 0) {
            return false;
        }

        if (prev.getNextpage02() == null || next.getNextpage02() == null) {
            if (prev.getNextpage02() != next.getNextpage02()) {
                return false;
            }
        } else if (prev.getNextpage02().compareTo(next.getNextpage02()) != 0) {
            return false;
        }

        if (prev.getHidden01() == null || next.getHidden01() == null) {
            if (prev.getHidden01() != next.getHidden01()) {
                return false;
            }
        } else if (prev.getHidden01().compareTo(next.getHidden01()) != 0) {
            return false;
        }

        return true;
    }

    /**
     * L[ɂAy[WWł邩ǂ`FbNB
     *
     * @param prev rB
     * @param next rB
     * @return Wł邩ǂB
     */
    public boolean canConsolidatePageByKey(final Yoko02PdfReportItems prev, final Yoko02PdfReportItems next) {
        if (prev.getField01() == null || next.getField01() == null) {
            if (prev.getField01() != next.getField01()) {
                return false;
            }
        } else if (prev.getField01().compareTo(next.getField01()) != 0) {
            return false;
        }

        return true;
    }

    /**
     * ̍sƂɃy[Wu[N܂Bł̓y[W𕪊܂B
     *
     * @param itemsList u[NڌQB
     */
    public void breakPageByRowCount(final List<Yoko02PdfReportItems> itemsList) {
        for (int index = 0; index < itemsList.size(); index++) {
            final Yoko02PdfReportItems look = itemsList.get(index);
            if (look.getBlockList().size() > 5) {
                // y[W𕪊܂B
                final Yoko02PdfReportItems add = new Yoko02PdfReportItems();
                add.setPageNo(look.getPageNo());
                add.setTotalPageCount(look.getTotalPageCount());
                add.setField00(look.getField00());
                add.setField01(look.getField01());
                add.setField02(look.getField02());
                add.setField03(look.getField03());
                add.setField04(look.getField04());
                add.setNextpage01(look.getNextpage01());
                add.setNextpage02(look.getNextpage02());
                add.setHidden01(look.getHidden01());

                for (int indexBlock = 0; indexBlock < 5; indexBlock++) {
                    add.getBlockList().add(look.getBlockList().get(0));
                    look.getBlockList().remove(0);
                }
                itemsList.add(index, add);
            }
        }
    }

    /**
     * y[W̌pɊւ鏈{܂B
     *
     * @param itemsList ΏہB
     */
    public void processPageContinuity(final List<Yoko02PdfReportItems> itemsList) {
        Yoko02PdfReportItems prev = null;
        for (int index = 0; index < itemsList.size(); index++) {
            final Yoko02PdfReportItems next = itemsList.get(index);
            if (prev == null) {
                prev = next;
                continue;
            }

            // ڂ̒lL[ƂɔrB
            if (canConsolidatePageByKey(prev, next)) {
                prev.setNextpage02(null);
            } else {
                prev.setNextpage01(null);
            }
            prev = next;
        }
        prev.setNextpage01(null);
    }

    /**
     * y[Wԍt^B
     *
     * @param itemsList y[WڌQB
     */
    public void applyPageNo(final List<Yoko02PdfReportItems> itemsList) {
        int pageNo = 1;
        for (Yoko02PdfReportItems items : itemsList) {
            items.setPageNo(BigDecimal.valueOf(pageNo++));
        }
        for (Yoko02PdfReportItems items : itemsList) {
            items.setTotalPageCount(BigDecimal.valueOf(itemsList.size()));
        }
    }

    /**
     * ㍀ڂ̏ȗ{B
     *
     * @param itemsList ȗڌQB
     */
    public void omitDitto(final List<Yoko02PdfReportItems> itemsList) {
        for (Yoko02PdfReportItems items : itemsList) {
            int prevLayer = 0;
            String prevBlock01 = null;
            String prevBlock02 = null;
            for (int index = 0; index < items.getBlockList().size(); index++) {
                final Yoko02PdfReportBlockItems next = items.getBlockList().get(index);
                if (prevLayer != next.getLayer()) {
                    prevBlock01 = null;
                    prevBlock02 = null;
                    continue;
                }
                if (prevBlock01 == null || next.getBlock01() == null) {
                    if (prevBlock01 == next.getBlock01()) {
                        // L[ڂv܂B
                        next.setBlock01(null);
                    } else {
                        // L[ڂv܂łB
                        prevBlock01 = next.getBlock01();
                        prevBlock02 = null;
                    }
                } else if (prevBlock01.compareTo(next.getBlock01()) == 0) {
                    // L[ڂv܂B
                    next.setBlock01(null);
                } else {
                    // L[ڂv܂łB
                    prevBlock01 = next.getBlock01();
                    prevBlock02 = null;
                }
                if (prevBlock02 == null || next.getBlock02() == null) {
                    if (prevBlock02 == next.getBlock02()) {
                        // L[ڂv܂B
                        next.setBlock02(null);
                    } else {
                        // L[ڂv܂łB
                        prevBlock02 = next.getBlock02();
                    }
                } else if (prevBlock02.compareTo(next.getBlock02()) == 0) {
                    // L[ڂv܂B
                    next.setBlock02(null);
                } else {
                    // L[ڂv܂łB
                    prevBlock02 = next.getBlock02();
                }
            }
        }
    }

    /**
     * L[ɍs𕡐B
     *
     * @param itemsList ڌQB
     */
    public void dupRowByKey(final List<Yoko02PdfReportItems> itemsList) {
        for (Yoko02PdfReportItems items : itemsList) {
            int prevLayer = 0;
            Yoko02PdfReportBlockItems prev = null;
            String prevBlock01 = null;
            String prevBlock02 = null;
            for (int index = 0; index < items.getBlockList().size(); index++) {
                final Yoko02PdfReportBlockItems next = items.getBlockList().get(index);
                if (prevLayer != next.getLayer()) {
                    prevBlock01 = null;
                    prevBlock02 = null;
                    prev = next;
                    continue;
                }
                if (prevBlock01 == null || next.getBlock01() == null) {
                    if (prevBlock01 == next.getBlock01()) {
                        // L[ڂv܂B
                    } else {
                        // L[ڂv܂łB
                        prevBlock01 = next.getBlock01();
                        prevBlock02 = null;
                        // ɕB
                        if (prev != null) {
                            final Yoko02PdfReportBlockItems add = new Yoko02PdfReportBlockItems();
                            items.getBlockList().add(index++, add);
                            add.setLayer(2);
                            add.setBlock01(prev.getBlock01());
                            add.setGokei01(prev.getGokei01());
                            add.setBlock02(prev.getBlock02());
                            add.setBlock03(prev.getBlock03());
                            add.setBlock04(prev.getBlock04());
                        }
                        {
                            final Yoko02PdfReportBlockItems add = new Yoko02PdfReportBlockItems();
                            items.getBlockList().add(index++, add);
                            add.setLayer(1);
                            add.setBlock01(next.getBlock01());
                            add.setGokei01(next.getGokei01());
                            add.setBlock02(next.getBlock02());
                            add.setBlock03(next.getBlock03());
                            add.setBlock04(next.getBlock04());
                        }
                    }
                } else if (prevBlock01.compareTo(next.getBlock01()) == 0) {
                    // L[ڂv܂B
                } else {
                    // L[ڂv܂łB
                    prevBlock01 = next.getBlock01();
                    prevBlock02 = null;
                    // ɕB
                    if (prev != null) {
                        final Yoko02PdfReportBlockItems add = new Yoko02PdfReportBlockItems();
                        items.getBlockList().add(index++, add);
                        add.setLayer(2);
                        add.setBlock01(prev.getBlock01());
                        add.setGokei01(prev.getGokei01());
                        add.setBlock02(prev.getBlock02());
                        add.setBlock03(prev.getBlock03());
                        add.setBlock04(prev.getBlock04());
                    }
                    {
                        final Yoko02PdfReportBlockItems add = new Yoko02PdfReportBlockItems();
                        items.getBlockList().add(index++, add);
                        add.setLayer(1);
                        add.setBlock01(next.getBlock01());
                        add.setGokei01(next.getGokei01());
                        add.setBlock02(next.getBlock02());
                        add.setBlock03(next.getBlock03());
                        add.setBlock04(next.getBlock04());
                    }
                }
                if (prevBlock02 == null || next.getBlock02() == null) {
                    if (prevBlock02 == next.getBlock02()) {
                        // L[ڂv܂B
                    } else {
                        // L[ڂv܂łB
                        prevBlock02 = next.getBlock02();
                        // ɕB
                    }
                } else if (prevBlock02.compareTo(next.getBlock02()) == 0) {
                    // L[ڂv܂B
                } else {
                    // L[ڂv܂łB
                    prevBlock02 = next.getBlock02();
                    // ɕB
                }
                prev = next;
            }
            if (prev != null) {
                final Yoko02PdfReportBlockItems add = new Yoko02PdfReportBlockItems();
                items.getBlockList().add(add);
                add.setLayer(2);
                add.setBlock01(prev.getBlock01());
                add.setGokei01(prev.getGokei01());
                add.setBlock02(prev.getBlock02());
                add.setBlock03(prev.getBlock03());
                add.setBlock04(prev.getBlock04());
            }
        }
    }

    /**
     * ObhEV[g`悵܂B
     */
    public void drawGridSheet() {
        fPageWriter.drawGridSheet();
    }

    /**
     * N[Y܂B
     */
    public void close() {
        fPageWriter.close();
    }

    /**
     * PDF C^[擾܂B
     *
     * @return IɗpĂ郉C^[B
     */
    @Deprecated
    public PdfWriter getPdfWriter() {
        return fPageWriter.getWriter();
    }
}
