package blanco.eclipseast2cg.util;

import java.util.Map;

import junit.framework.TestCase;

import org.junit.Test;

public class BlancoEclipseASTAnnotationUtilTest extends TestCase {

    @Test
    public void testParseNormalAnnotation01() throws Exception {
        final String SOURCE = "@NormalAnnotationTypeSample(value1 = \"OverridedValue1\",value2 = \"OverridedValue2\")";
        assertEquals("NormalAnnotationTypeSample",
                BlancoEclipseASTAnnotationUtil.getAnnotationTypeName(SOURCE));

        final Map<String, String> result = BlancoEclipseASTAnnotationUtil
                .getAnnotationMemberValuePair(SOURCE);
        assertEquals("\"OverridedValue1\"", result.get("value1"));
    }

    @Test
    public void testParseNormalAnnotation02() throws Exception {
        final String SOURCE = "@NormalAnnotationTypeSample()";
        assertEquals("NormalAnnotationTypeSample",
                BlancoEclipseASTAnnotationUtil.getAnnotationTypeName(SOURCE));
    }

    @Test
    public void testParseNormalAnnotation03() throws Exception {
        final String SOURCE = "@NormalAnnotationTypeSample";
        assertEquals("NormalAnnotationTypeSample",
                BlancoEclipseASTAnnotationUtil.getAnnotationTypeName(SOURCE));
    }
}
