/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2011 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2011 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
package blanco.eclipseast2cg.util;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class BlancoEclipseASTAnnotationUtil {
    static final boolean IS_DEBUG = false;

    /**
     * NormalAnnotation を解析するためのツール。
     * 
     * @param annotationString
     *            「@NormalAnnotationTypeSample(value1="OverridedValue1",value2=
     *            "OverridedValue2")」のように渡します。
     */
    public static NormalAnnotation parseNormalAnnotation(final String annotationString) {
        if (IS_DEBUG)
            System.out.println("BlancoEclipseASTAnnotationUtil#parseNormalAnnotation(" + annotationString + ")");

        final NormalAnnotation[] result = new NormalAnnotation[1];

        final String sourceCode = annotationString + " public class NormalAnnotationUtil {}";

        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(sourceCode.toCharArray());
        final CompilationUnit unit = (CompilationUnit) parser.createAST(new NullProgressMonitor());

        unit.accept(new ASTVisitor() {
            @Override
            public boolean visit(final NormalAnnotation node) {
                result[0] = node;

                return super.visit(node);
            }
        });

        if (IS_DEBUG)
            System.out.println("BlancoEclipseASTAnnotationUtil#parseNormalAnnotation(" + annotationString + ") == "
                    + result[0]);

        return result[0];
    }

    public static MarkerAnnotation parseMarkerAnnotation(final String annotationString) {
        final MarkerAnnotation[] result = new MarkerAnnotation[1];

        final String sourceCode = annotationString + " public class MarkerAnnotationUtil {}";

        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(sourceCode.toCharArray());
        final CompilationUnit unit = (CompilationUnit) parser.createAST(new NullProgressMonitor());

        unit.accept(new ASTVisitor() {
            @Override
            public boolean visit(MarkerAnnotation node) {
                result[0] = node;
                return super.visit(node);
            }
        });

        return result[0];
    }

    public static SingleMemberAnnotation parseSingleMemberAnnotation(final String annotationString) {

        final SingleMemberAnnotation[] result = new SingleMemberAnnotation[1];

        final String sourceCode = annotationString + " public class SingleMemberAnnotationUtil {}";

        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(sourceCode.toCharArray());
        final CompilationUnit unit = (CompilationUnit) parser.createAST(new NullProgressMonitor());

        unit.accept(new ASTVisitor() {
            @Override
            public boolean visit(SingleMemberAnnotation node) {
                result[0] = node;
                return super.visit(node);
            }
        });

        return result[0];
    }

    /**
     * 与えられたアノテーション記述から型名を取得します。
     * 
     * @param annotationString
     * @return
     */
    public static String getAnnotationTypeName(final String annotationString) {
        {
            final NormalAnnotation node = parseNormalAnnotation(annotationString);
            if (node != null)
                return node.getTypeName().getFullyQualifiedName();
        }
        {
            final MarkerAnnotation node = parseMarkerAnnotation(annotationString);
            if (node != null)
                return node.getTypeName().getFullyQualifiedName();
        }
        {
            final SingleMemberAnnotation node = parseSingleMemberAnnotation(annotationString);
            if (node != null)
                return node.getTypeName().getFullyQualifiedName();
        }

        throw new IllegalArgumentException("Unexcepted annotation string '" + annotationString + "' is passed.");
    }

    /**
     * 与えられたアノテーション記述からメンバーのキー・値のペアを取得します。
     * 
     * @param annotationString
     * @return
     */
    public static Map<String, String> getAnnotationMemberValuePair(final String annotationString) {
        final Map<String, String> result = new HashMap<String, String>();
        {
            final NormalAnnotation node = parseNormalAnnotation(annotationString);
            if (node != null) {
                for (Object obj : node.values()) {
                    final MemberValuePair pair = (MemberValuePair) obj;
                    result.put(pair.getName().toString(), pair.getValue().toString());
                }
                return result;
            }
        }
        {
            final MarkerAnnotation node = parseMarkerAnnotation(annotationString);
            if (node != null) {
                // Do nothing.
                return result;
            }
        }
        {
            final SingleMemberAnnotation node = parseSingleMemberAnnotation(annotationString);
            if (node != null) {
                result.put("value", node.getValue().toString());
            }
        }

        return result;
    }
}
