/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;

public class BlancoMailReceiverSample {
    /**
     * blancoMailCorep[MTvB
     * 
     * @param args
     *            ̓p[^B
     * @throws ConnectException
     *             ڑOꍇB
     * @throws IOException
     *             [MɗOꍇB
     */
    public static void main(final String[] args) throws ConnectException,
            IOException {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setReceiveHost("pop.gmail.com");
            setting.setReceivePort(995);
            setting.setReceiveUseSsl(true);
            setting.setReceiveUserName("Mҁ@gmail.com");
            setting.setReceivePassword("password");
            // setting.setSessionLogDirectorySuccess("./log");
            // setting.setSessionLogDirectoryError("./log.err");
        }

        final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                .getInstance();
        final BlancoMailMessage message = receiver.receive(setting);
        if (message != null) {
            System.out.println(message.getSubject());
            System.out.println(message.toString());
        }
    }
}
