/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2011-2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2011-2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2011-2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package blanco.unicode.util;

/**
 * Unicode のための各種ユーティリティ。
 * 
 * @author Toshiki Iga
 */
public class BlancoUnicodeUtil {
	/**
	 * 与えられた文字列について、正規化をおこないます。
	 * 
	 * <ul>
	 * <li>Microsoft Windows 日本語版形式特有の形式から標準的な Unicode の形式に変換します</li>
	 * </ul>
	 * 
	 * @param input
	 *            変換もとの文字列。
	 * @return 正規化されたあとの文字列。
	 */
	public static String normalizeUnicode(final String input) {
		return normalizeWindows31jToStandard(input);
	}

	/**
	 * あたえられた文字列について、Microsoft Windows 日本語版形式特有の形式から標準的な Unicode の形式に変換します。
	 * 
	 * @param original
	 *            入力文字列。
	 * @return 変換後の文字列。
	 */
	private static String normalizeWindows31jToStandard(final String original) {
		if (original == null) {
			// null があたえられた場合には null を戻します。
			return null;
		}

		// 文字列が変更されたかどうか。
		boolean isModified = false;

		final char[] charArray = original.toCharArray();
		for (int index = 0; index < charArray.length; index++) {
			switch (charArray[index]) {
			case '\u2225':
				// From: PARALLEL TO
				// To: DOUBLE VERTICAL LINE
				// full width to half width.
				charArray[index] = '\u2016';
				isModified = true;
				break;
			case '\uFF0D':
				// From: FULLWIDTH HYPHEN-MINUS
				// To: MINUS SIGN
				// full width to half width.
				charArray[index] = '\u2212';
				isModified = true;
				break;
			}
		}

		if (isModified == false) {
			// 変更はありませんでした。そのまま返却します。
			return original;
		}

		// 変更があった場合のみ文字列を生成します。
		return new String(charArray);
	}
}
