/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2004-2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2004-2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2004-2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package blanco.mail.core;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;
import blanco.mail.core.valueobject.BlancoMailStatistics;

/**
 * [MC^tF[XB
 * 
 * blancoMailCorẽ[M̃C^tF[Xdl܂B
 * NX擾邽߂ɂ́ABlancoMailSenderFactory#getInstance 𗘗p܂B
 * 
 * @author IGA Tosiki
 */
public interface BlancoMailSender {
    /**
     * [T[oɁA[𑗐M܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏Ă܂B
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     * @throws IOException
     *             [f[^MsɊւOB
     */
    void send(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage) throws ConnectException,
            IOException;

    /**
     * v擾̂߂̃o[IuWFNgZbg܂B
     * 
     * @param argStatistics
     *            vB
     */
    void setStatistics(final BlancoMailStatistics argStatistics);

    /**
     * v擾̂߂̃o[IuWFNgQbg܂B
     * 
     * @return vB
     */
    BlancoMailStatistics getStatistics();
}