/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobjectfactory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.resourcebundle.BlancoResourceBundleXmlParser;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;
import blanco.valueobject.BlancoValueObjectXmlParser;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;
import blanco.valueobjectfactory.resourcebundle.BlancoValueObjectFactoryResourceBundle;
import blanco.valueobjectfactory.valueobject.BlancoValueObjectFactoryStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uo[IuWFNgt@Ng`vExcell o[IuWFNĝ߂̃t@NgNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectFactoryXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoValueObjectFactoryResourceBundle fBundle = new BlancoValueObjectFactoryResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * ̃NX̎傽郁\bhƂȂ܂B
     * 
     * 炩߁Ao[IuWFNg̃}bvƃ\[Xoh̃}bvĂĂ炱̃\bhĂяo܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argValueObjectMap
     *            o[IuWFNg̃}bvB
     * @param argResourceBundleMap
     *            \[Xoh̃}bvB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final HashMap argValueObjectMap,
            final HashMap argResourceBundleMap, final File argDirectoryTarget)
            throws IOException {
        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument xmlDocument = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(xmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // f[^\[X擾܂B
            final BlancoXmlElement elementDataSource = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementDatasource());

            // V[gڍׂȏ擾܂B
            final BlancoValueObjectFactoryStructure processStructure = parseSheet(
                    elementCommon, elementDataSource, argDirectoryTarget);
            if (processStructure == null) {
                continue;
            }

            if (processStructure.getName() == null) {
                throw new IllegalArgumentException("肦ȂI̓_B");
            }

            // ^̉͌ʂƂɃ\[XR[hs܂B

            if (argValueObjectMap.get(processStructure.getName()) == null) {
                // Ȃ̂͗OB
                throw new IllegalArgumentException("o[IuWFNgt@Ng`["
                        + processStructure.getName()
                        + "]ɑΉo[IuWFNg܂");
            }

            if (argResourceBundleMap.get(processStructure
                    .getDataSourceResourceBundle()) == null) {
                // Ȃ̂͗OB
                throw new IllegalArgumentException("o[IuWFNgt@Ng`["
                        + processStructure.getName() + "]ɑΉ郊\[Xoh["
                        + processStructure.getDataSourceResourceBundle()
                        + "]܂");
            }

            final BlancoValueObjectClassStructure valueObjectClassStructure = (BlancoValueObjectClassStructure) argValueObjectMap
                    .get(processStructure.getName());
            final BlancoResourceBundleBundleStructure resourceBundleClassStructure = (BlancoResourceBundleBundleStructure) argResourceBundleMap
                    .get(processStructure.getDataSourceResourceBundle());

            expandSourceFile(processStructure, valueObjectClassStructure,
                    resourceBundleClassStructure, argDirectoryTarget);
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param elementBindtarget
     *            ݏĂBindtargetm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoValueObjectFactoryStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final BlancoXmlElement elementBindtarget,
            final File argDirectoryTarget) {

        final BlancoValueObjectFactoryStructure processStructure = new BlancoValueObjectFactoryStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (processStructure.getName() == null) {
            // ̂null̂̂ɂĂ XLbv܂B
            return null;
        }

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (elementBindtarget == null) {
            // TODO OI
        }

        processStructure.setDataSourceResourceBundle(BlancoXmlBindingUtil
                .getTextContent(elementBindtarget, "resourceBundle"));

        // TODO ^[Qbg̃\[Xohw̓G[I

        return processStructure;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argValueObjectClassStructure
     *            ֘Atꂽo[IuWFNgB
     * @param argResourceBundleClassStructure
     *            ֘Atꂽf[^\[X̃\[XohB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    private void expandSourceFile(
            final BlancoValueObjectFactoryStructure argProcessStructure,
            final BlancoValueObjectClassStructure argValueObjectClassStructure,
            final BlancoResourceBundleBundleStructure argResourceBundleClassStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName()
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argProcessStructure
                        .getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getLangDoc().getDescriptionList().add(
                "o[IuWFNg[" + argValueObjectClassStructure.getName()
                        + "]̃CX^XK؂ȃftHgltŎ擾邽߂̃NXB");

        expandField(argProcessStructure);
        expandMethodConstructor(argProcessStructure);
        expandMethodGetInstance(argProcessStructure,
                argValueObjectClassStructure, argResourceBundleClassStructure);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandField(
            final BlancoValueObjectFactoryStructure argProcessStructure) {
        // tB[h͓ɂ܂B
    }

    /**
     * RXgN^WJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodConstructor(
            final BlancoValueObjectFactoryStructure argProcessStructure) {
        // RXgN^WJ܂B

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(fCgClass
                .getName(), "RXgN^͉B܂B");
        cgMethod.setConstructor(true);
        cgMethod.setAccess("private");
        fCgClass.getMethodList().add(cgMethod);
    }

    /**
     * getInstance \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argValueObjectClassStructure
     *            ֘Atꂽo[IuWFNgB
     * @param argResourceBundleClassStructure
     *            ֘Atꂽf[^\[X̃\[XohB
     */
    private void expandMethodGetInstance(
            final BlancoValueObjectFactoryStructure argProcessStructure,
            final BlancoValueObjectClassStructure argValueObjectClassStructure,
            final BlancoResourceBundleBundleStructure argResourceBundleClassStructure) {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("getInstance",
                BlancoCgSourceUtil.escapeStringAsLangDoc(
                        BlancoCgSupportedLang.JAVA, "o[IuWFNg["
                                + argValueObjectClassStructure.getName()
                                + "]̃CX^X擾܂B"));
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setStatic(true);
        cgMethod.getLangDoc().getDescriptionList().add(
                "\[Xoh(ꖼ:"
                        + argResourceBundleClassStructure.getName()
                        + ", NX:"
                        + argResourceBundleClassStructure.getName()
                        + BlancoStringUtil
                                .null2Blank(argResourceBundleClassStructure
                                        .getSuffix()) + ")ftHgl̓ǂݍ݂݂܂B");

        final String targetValueObjectClassName = argValueObjectClassStructure
                .getPackage()
                + "." + argValueObjectClassStructure.getName();
        final String targetResourceBundleClassName = argResourceBundleClassStructure
                .getPackage()
                + "."
                + argResourceBundleClassStructure.getName()
                + argResourceBundleClassStructure.getSuffix();

        cgMethod.setReturn(fCgFactory.createReturn(targetValueObjectClassName,
                "ftHglς݂[" + argValueObjectClassStructure.getName()
                        + "]o[IuWFNgB"));

        final List lineList = cgMethod.getLineList();

        // TODO \[Xoh`ŃTtBbNX𖳎ŵւ̑Ή
        // TODO `̎w悪Ȃꍇ̑ΉB

        fCgSourceFile.getImportList().add(targetResourceBundleClassName);

        lineList.add("// ̃\bh̎sʂƂȂo[IuWFNgCX^XB");
        lineList.add("final " + argValueObjectClassStructure.getName()
                + " result = new " + argValueObjectClassStructure.getName()
                + "();");
        lineList.add("");
        lineList.add("// o[IuWFNgɐݒ肷ftHgl̂߂̃f[^\[XCX^XB");
        lineList.add("final "
                + BlancoNameUtil.trimJavaPackage(targetResourceBundleClassName)
                + " bundle = new "
                + BlancoNameUtil.trimJavaPackage(targetResourceBundleClassName)
                + "();");
        lineList.add("");

        for (int index = 0; index < argValueObjectClassStructure.getFieldList()
                .size(); index++) {
            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) argValueObjectClassStructure
                    .getFieldList().get(index);
            lineList.add("// tB[h [" + field.getName() + "]");

            if ("java.lang.String".equals(field.getType())) {
                // ̏ꍇ
                lineList.add("if (bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "() != null && bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "().length() > 0) {");
                lineList.add("result.set"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "(bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "());");
                lineList.add("}");
            } else if ("int".equals(field.getType())) {
                // l̏ꍇ
                lineList.add("if (bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "() != null && bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "().length() > 0) {");
                lineList.add("try {");
                lineList.add("result.set"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "(Integer.parseInt(bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "()));");
                lineList.add("} catch (NumberFormatException e) {");
                lineList.add("// ܂B");
                lineList.add("}");
                lineList.add("}");
            } else if ("boolean".equals(field.getType())) {
                // l̏ꍇ
                lineList.add("if (bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "() != null && bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "().length() > 0) {");
                lineList.add("result.set"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "(\"true\".equals(bundle.get"
                        + BlancoNameAdjuster.toClassName(field.getName())
                        + "()));");
                lineList.add("}");
            } else {
                lineList.add("// T|[gǑ^ [" + field.getType() + "]");
            }

            lineList.add("");
        }

        lineList.add("return result;");
    }

    // [eBeBIȃ\bh

    /**
     * w肳ꂽfBNg̒Ɋ܂܂o[IuWFNg(XML)SĎ擾܂B
     * 
     * @param argTargetDirectory
     *            o[IuWFNg(XML)i[ĂfBNgB
     * @param argMapResult
     *            Wꂽo[IuWFNgB
     */
    public static void processBlancoValueObjectXmlDirectory(
            final File argTargetDirectory, final HashMap argMapResult) {
        final File[] fileMeta = argTargetDirectory.listFiles();
        for (int index = 0; index < fileMeta.length; index++) {
            if (fileMeta[index].getName().endsWith(".xml") == false) {
                continue;
            }

            final BlancoValueObjectClassStructure[] structures = new BlancoValueObjectXmlParser()
                    .parse(fileMeta[index]);
            for (int indexStructure = 0; indexStructure < structures.length; indexStructure++) {
                argMapResult.put(structures[indexStructure].getName(),
                        structures[indexStructure]);
            }
        }
    }

    /**
     * w肳ꂽfBNg̒Ɋ܂܂郊\[Xoh(XML)SĎ擾܂B
     * 
     * @param argTargetDirectory
     *            \[Xoh(XML)i[ĂfBNgB
     * @param argMapResult
     *            Wꂽ\[XohB
     */
    public static void processBlancoResourceBundleXmlDirectory(
            final File argTargetDirectory, final HashMap argMapResult) {
        final File[] fileMeta = argTargetDirectory.listFiles();
        for (int index = 0; index < fileMeta.length; index++) {
            if (fileMeta[index].getName().endsWith(".xml") == false) {
                continue;
            }

            final BlancoResourceBundleBundleStructure[] structures = new BlancoResourceBundleXmlParser()
                    .parse(fileMeta[index]);
            for (int indexStructure = 0; indexStructure < structures.length; indexStructure++) {
                argMapResult.put(structures[indexStructure].getName(),
                        structures[indexStructure]);
            }
        }
    }
}
