/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.mail.core.valueobject;

/**
 * [̓Ytt@C킷o[IuWFNgBYtt@CYtt@C̃f[^̂̂i[܂B
 */
public class BlancoMailMessageAttachment {
    /**
     * Ytt@C̃t@CB (send) ḾAKw肵ĂB
     *
     * tB[h: [FILE_NAME]B
     */
    private String fFileName;

    /**
     * Ytt@C̃f[^BoCgzŎ󂯓n܂B̂߁AJavaVM̃ʂɋCȂĂ͂ȂȂ_ɒӂĂBX blancoMailCorẽZbVO̎@̓̂߁AYtt@C̃f[^TCY x 1.4xɉāAɓYtt@Cf[^TCY x 1.4 x̃KvɂȂ܂B
     *
     * tB[h: [DATA]B
     */
    private byte[] fData;

    /**
     * Ytt@CŗpMIME^CvB
     *
     * tB[h: [MIME_TYPE]B
     * ftHg: ["application/octet-stream"]B
     */
    private String fMimeType = "application/octet-stream";

    /**
     * (receive) [̃TCYB
     *
     * tB[h: [SIZE]B
     * ftHg: [-1]B
     */
    private int fSize = -1;

    /**
     * (receive) [̍sB
     *
     * tB[h: [LINE_COUNT]B
     * ftHg: [-1]B
     */
    private int fLineCount = -1;

    /**
     * (receive) Reg^CvB
     *
     * tB[h: [CONTENT_TYPE]B
     */
    private String fContentType;

    /**
     * (receive) descriptionB
     *
     * tB[h: [DESCRIPTION]B
     */
    private String fDescription;

    /**
     * (receive) dispositionB
     *
     * tB[h: [DISPOSITION]B
     */
    private String fDisposition;

    /**
     * tB[h [FILE_NAME] ̒lݒ肵܂B
     *
     * tB[h̐: [Ytt@C̃t@CB (send) ḾAKw肵ĂB]B
     *
     * @param argFileName tB[h[FILE_NAME]ɐݒ肷lB
     */
    public void setFileName(final String argFileName) {
        fFileName = argFileName;
    }

    /**
     * tB[h [FILE_NAME] ̒l擾܂B
     *
     * tB[h̐: [Ytt@C̃t@CB (send) ḾAKw肵ĂB]B
     *
     * @return tB[h[FILE_NAME]擾lB
     */
    public String getFileName() {
        return fFileName;
    }

    /**
     * tB[h [DATA] ̒lݒ肵܂B
     *
     * tB[h̐: [Ytt@C̃f[^BoCgzŎ󂯓n܂B̂߁AJavaVM̃ʂɋCȂĂ͂ȂȂ_ɒӂĂBX blancoMailCorẽZbVO̎@̓̂߁AYtt@C̃f[^TCY x 1.4xɉāAɓYtt@Cf[^TCY x 1.4 x̃KvɂȂ܂B]B
     *
     * @param argData tB[h[DATA]ɐݒ肷lB
     */
    public void setData(final byte[] argData) {
        fData = argData;
    }

    /**
     * tB[h [DATA] ̒l擾܂B
     *
     * tB[h̐: [Ytt@C̃f[^BoCgzŎ󂯓n܂B̂߁AJavaVM̃ʂɋCȂĂ͂ȂȂ_ɒӂĂBX blancoMailCorẽZbVO̎@̓̂߁AYtt@C̃f[^TCY x 1.4xɉāAɓYtt@Cf[^TCY x 1.4 x̃KvɂȂ܂B]B
     *
     * @return tB[h[DATA]擾lB
     */
    public byte[] getData() {
        return fData;
    }

    /**
     * tB[h [MIME_TYPE] ̒lݒ肵܂B
     *
     * tB[h̐: [Ytt@CŗpMIME^CvB]B
     *
     * @param argMimeType tB[h[MIME_TYPE]ɐݒ肷lB
     */
    public void setMimeType(final String argMimeType) {
        fMimeType = argMimeType;
    }

    /**
     * tB[h [MIME_TYPE] ̒l擾܂B
     *
     * tB[h̐: [Ytt@CŗpMIME^CvB]B
     * ftHg: ["application/octet-stream"]B
     *
     * @return tB[h[MIME_TYPE]擾lB
     */
    public String getMimeType() {
        return fMimeType;
    }

    /**
     * tB[h [SIZE] ̒lݒ肵܂B
     *
     * tB[h̐: [(receive) [̃TCYB]B
     *
     * @param argSize tB[h[SIZE]ɐݒ肷lB
     */
    public void setSize(final int argSize) {
        fSize = argSize;
    }

    /**
     * tB[h [SIZE] ̒l擾܂B
     *
     * tB[h̐: [(receive) [̃TCYB]B
     * ftHg: [-1]B
     *
     * @return tB[h[SIZE]擾lB
     */
    public int getSize() {
        return fSize;
    }

    /**
     * tB[h [LINE_COUNT] ̒lݒ肵܂B
     *
     * tB[h̐: [(receive) [̍sB]B
     *
     * @param argLineCount tB[h[LINE_COUNT]ɐݒ肷lB
     */
    public void setLineCount(final int argLineCount) {
        fLineCount = argLineCount;
    }

    /**
     * tB[h [LINE_COUNT] ̒l擾܂B
     *
     * tB[h̐: [(receive) [̍sB]B
     * ftHg: [-1]B
     *
     * @return tB[h[LINE_COUNT]擾lB
     */
    public int getLineCount() {
        return fLineCount;
    }

    /**
     * tB[h [CONTENT_TYPE] ̒lݒ肵܂B
     *
     * tB[h̐: [(receive) Reg^CvB]B
     *
     * @param argContentType tB[h[CONTENT_TYPE]ɐݒ肷lB
     */
    public void setContentType(final String argContentType) {
        fContentType = argContentType;
    }

    /**
     * tB[h [CONTENT_TYPE] ̒l擾܂B
     *
     * tB[h̐: [(receive) Reg^CvB]B
     *
     * @return tB[h[CONTENT_TYPE]擾lB
     */
    public String getContentType() {
        return fContentType;
    }

    /**
     * tB[h [DESCRIPTION] ̒lݒ肵܂B
     *
     * tB[h̐: [(receive) descriptionB]B
     *
     * @param argDescription tB[h[DESCRIPTION]ɐݒ肷lB
     */
    public void setDescription(final String argDescription) {
        fDescription = argDescription;
    }

    /**
     * tB[h [DESCRIPTION] ̒l擾܂B
     *
     * tB[h̐: [(receive) descriptionB]B
     *
     * @return tB[h[DESCRIPTION]擾lB
     */
    public String getDescription() {
        return fDescription;
    }

    /**
     * tB[h [DISPOSITION] ̒lݒ肵܂B
     *
     * tB[h̐: [(receive) dispositionB]B
     *
     * @param argDisposition tB[h[DISPOSITION]ɐݒ肷lB
     */
    public void setDisposition(final String argDisposition) {
        fDisposition = argDisposition;
    }

    /**
     * tB[h [DISPOSITION] ̒l擾܂B
     *
     * tB[h̐: [(receive) dispositionB]B
     *
     * @return tB[h[DISPOSITION]擾lB
     */
    public String getDisposition() {
        return fDisposition;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.mail.core.valueobject.BlancoMailMessageAttachment[");
        buf.append("FILE_NAME=" + fFileName);
        if (fData == null) {
            buf.append(",DATA=null");
        } else {
            buf.append(",DATA=[");
            for (int index = 0; index < fData.length; index++) {
                buf.append((index == 0 ? "" : ", ") + fData[index]);
            }
            buf.append("]");
        }
        buf.append(",MIME_TYPE=" + fMimeType);
        buf.append(",SIZE=" + fSize);
        buf.append(",LINE_COUNT=" + fLineCount);
        buf.append(",CONTENT_TYPE=" + fContentType);
        buf.append(",DESCRIPTION=" + fDescription);
        buf.append(",DISPOSITION=" + fDisposition);
        buf.append("]");
        return buf.toString();
    }
}
