/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core.mobilephone;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.BlancoMailSenderFactory;
import blanco.mail.core.BlancoMailSettingFactory;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailSetting;

/**
 * p^[1B
 */
public class BlancoMailMobilePhoneTestSender001 {
    public static void main(final String[] args) throws ConnectException,
            IOException {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            // setting.setSendHost("smtp.gmail.com");
            // setting.setSendPort(465);
        }

        final BlancoMailMessage message = new BlancoMailMessage();
        final BlancoMailAddress from = new BlancoMailAddress();
        from.setAddress(BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR);
        from
                .setPersonal(BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR_PERSONAL);
        message.setFrom(from);

        final BlancoMailAddress to1 = new BlancoMailAddress();
        to1.setAddress(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR);
        to1
                .setPersonal(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR_PERSONAL);
        message.getTo().add(to1);

        message.setSubject("[blanco](No.001) {sON, Ytt@C");
        message
                .setText(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR_PERSONAL
                        + "B"
                        + BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR_PERSONAL
                        + "łB\n"
                        + "́uJavaMail{{[vŗL̖ɑ΂鎎łB\n"
                        + "{s (SEND_FORTH_NEWLINE_AFTER_MESSAGE_TEXT): true\n"
                        + "Ytt@CtB");

        // {s
        setting.setSendForthNewlineAfterMessageText(true);

        // Ytt@C
        final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
        attachment.setData("Ytt@C".getBytes());
        attachment.setFileName("aaa.txt");
        message.getAttachmentList().add(attachment);

        System.out.println(message.getSubject() + ": " + to1.toString());

        BlancoMailSenderFactory.getInstance().send(setting, message);
    }
}
