package blanco.eclipseast2cg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;

import junit.framework.TestCase;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

public class BlancoEclipseAST2CgParserTest extends TestCase {

    public void testParseFile() throws Exception {
        final BlancoEclipseAST2CgParser parser = new BlancoEclipseAST2CgParser();
        final BlancoCgSourceFile cgSource = parser.parse(new File(
                "./src/blanco/eclipseast2cg/BlancoEclipseAST2CgParser.java"));
        for (BlancoCgClass cgClass : cgSource.getClassList()) {
            System.out.println(cgClass.toString());
            for (BlancoCgMethod cgMethod : cgClass.getMethodList()) {
                for (String doc : cgMethod.getLangDoc().getDescriptionList()) {
                    System.out.println("doc:" + doc.toString());
                }
            }
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(cgSource,
                new BufferedWriter(new OutputStreamWriter(System.out, "Shift_JIS")));
    }

    public void testParseFile02() throws Exception {
        final BlancoEclipseAST2CgParser parser = new BlancoEclipseAST2CgParser();
        final BlancoCgSourceFile cgSource = parser.parse(new File(
                "./src/blanco/eclipseast2cg/BlancoEclipseAST2CgVisitor.java"));

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(cgSource,
                new BufferedWriter(new OutputStreamWriter(System.out, "Shift_JIS")));
    }
}
