package blanco.mail.core;

import java.io.IOException;
import java.net.ConnectException;

import blanco.commons.util.BlancoStringUtil;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;

public class BlancoMailSenderMojibakeTester {
	private static final String MAIL_SENDER_HOST = "localhost";
	private static final String MAIL_SENDER_USER = "user";
	private static final String MAIL_SENDER_PASS = "password";

	private static final String MAIL_FROM = "mailfrom.localhost";
	private static final String MAIL_TO = "mailto.localhost";

	/**
	 * Entry point for Mail Mojibake.
	 * 
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		// 20 to 7e
		{
			final StringBuilder builder = new StringBuilder();
			for (int m1 = 0x20; m1 <= 0x7e; m1++) {
				final byte[] arg = { (byte) m1 };
				final String value = new String(arg, "Windows-31J");
				builder.append(value);
				builder.append("(" + BlancoStringUtil.toHexString(arg[0]) + ")");
			}
			new BlancoMailSenderMojibakeTester().process(builder.toString());
		}

		// a1 to df
		{
			final StringBuilder builder = new StringBuilder();
			for (int m1 = 0xa1; m1 <= 0xdf; m1++) {
				final byte[] arg = { (byte) m1 };
				final String value = new String(arg, "Windows-31J");
				builder.append(value);
				builder.append("(" + BlancoStringUtil.toHexString(arg[0]) + ")");
			}
			new BlancoMailSenderMojibakeTester().process(builder.toString());
		}

		// 2 byte
		for (int m1 = 0x81; m1 <= 0xef; m1++) {
			if (m1 >= 0xa0 && m1 <= 0xdf) {
				continue;
			}

			final StringBuilder builder = new StringBuilder();

			for (int m2 = 0x40; m2 < 0xfc; m2++) {
				if (m2 == 0x7f) {
					continue;
				}

				final byte[] arg = { (byte) m1, (byte) m2 };
				final String value = new String(arg, "Windows-31J");
				builder.append(value);
				builder.append("(" + BlancoStringUtil.toHexString(arg[0])
						+ BlancoStringUtil.toHexString(arg[1]) + ")");
			}

			new BlancoMailSenderMojibakeTester().process(builder.toString());
		}

	}

	public void process(final String mojibakeTest) throws ConnectException,
			IOException {

		final String message = "[blancoMailCoreTest] mojibake check string ["
				+ mojibakeTest + "]";

		final BlancoMailAddress addrFrom = new BlancoMailAddress();
		addrFrom.setAddress(MAIL_FROM);
		addrFrom.setPersonal(message);

		final BlancoMailAddress addrTo = new BlancoMailAddress();
		addrTo.setAddress(MAIL_TO);
		addrTo.setPersonal(message);

		final BlancoMailSetting setting = BlancoMailSettingFactory
				.getInstance();
		setting.setSendHost(MAIL_SENDER_HOST);
		setting.setSendUserName(MAIL_SENDER_USER);
		setting.setSendPassword(MAIL_SENDER_PASS);

		final BlancoMailMessage msg = new BlancoMailMessage();
		msg.setFrom(addrFrom);
		msg.getTo().add(addrTo);
		msg.setSubject(message);
		msg.setText(message);

		BlancoMailSenderFactory.getInstance().send(setting, msg);
	}
}
