/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core.connect;

import java.io.IOException;
import java.net.ConnectException;

import junit.framework.TestCase;
import blanco.mail.core.BlancoMailReceiver;
import blanco.mail.core.BlancoMailReceiverFactory;
import blanco.mail.core.BlancoMailSettingFactory;
import blanco.mail.core.valueobject.BlancoMailSetting;

/**
 * ӁI
 * 
 * JUnitR[hsƁA[T[oւ̐ڑۂɍs܂B
 * 
 * JUnitR[hs邱Ƃ ܂BeǂŁAp̃[T[oȂǂĂs悤ɂĂB
 * 
 * @author IGA Tosiki
 */
public class BlancoMailReceiverConnectTest extends TestCase {
    /**
     * T^IȐݒl擾܂B
     * 
     * @return
     */
    private BlancoMailSetting getSetting() {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setReceiveHost("localhost");
            setting.setReceiveUserName("userName");
            setting.setReceivePassword("password");
        }

        return setting;
    }

    /**
     * MBMCR201͎Ă܂B
     * 
     * TODO MBMCR301 MBMCS308MBMCR901 _łJUnit{B
     * 
     * @throws Exception
     */
    public void testReceiveInput() throws Exception {
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveUserName("notexist");
            setting.setReceivePassword("failpassword");
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (ConnectException e) {
            assertTrue(e.getMessage().indexOf("MBMCR202") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveHost("localhost.notexist");
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (ConnectException e) {
            assertTrue(e.getMessage().indexOf("MBMCR203") >= 0);
        }
    }

    /**
     * ^CAEgn̎B
     * 
     * JUnit̓T[oɂ̓ȕׂ\܂B
     * 
     * @throws Exception
     */
    public void testReceiveTimeout() throws Exception {
        if (false)
            try {
                final BlancoMailSetting setting = getSetting();
                // ڑ^CAEg͊Ŕ肵Ȃ肵܂B
                // setting.setMailConnectionTimeout(1);
                setting.setMailTimeout(3);
                BlancoMailReceiverFactory.getInstance().receive(setting);
                fail("ׂOĂ܂B");
            } catch (IOException e) {
                // 1MB̃t@C̎M ̗O𔭐邱Ƃł܂B
                assertTrue("bZ[WID`FbN",
                        e.getMessage().indexOf("MBMCR301") >= 0);
            }
    }
}
