/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include "system.h"
#include "gcc.h"
#include "coretypes.h"
#include "tm.h"

void lang_specific_driver(int *in_argc, const char* const **in_argv,
                          int *in_added_libraries ATTRIBUTE_UNUSED) {
  int argc = *in_argc, i;
  const char *const *argv = *in_argv;

  for(i = 1; i < argc; ++i) {
    if(!strcmp (argv[i], "-fversion")) {
      printf("GCC buggy language (GCC %s)\n"
             "GCC buggy language comes with NO WARRANTY, "
             "to the extent permitted by law.\n"
             "You may redistribute copies of GCC buggy language\n"
             "under the terms of the GNU General Public License.\n"
             "For more information about these matters, "
             "see the file named COPYING\n", version_string);
      exit (0);
    }
  }
}

int lang_specific_pre_link(void){return 0;}
int lang_specific_extra_outfiles = 0;
