/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.testingframework;

import java.sql.Connection;
import java.sql.PreparedStatement;

import javax.sql.DataSource;

import jp.co.dgic.testing.framework.DJUnitTestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;

/**
 * djUnitにDBUnitをテストしやすく融合したクラス
 * 
 * @author takeda
 */
public class BliDbUnitTestCase extends DJUnitTestCase {

    protected ApplicationContext context      = null;

    protected String             truncateSql  = "";

    protected boolean            oracleFlag   = false;

    protected Log                log          = LogFactory.getLog( this
                                                      .getClass() );

    protected String             classNameStr = this.getClass().getSimpleName();


    /**
     * コンストラクタ
     */
    public BliDbUnitTestCase() {

        super();
    }


    /**
     * コンストラクタ
     * @param name
     */
    public BliDbUnitTestCase( String name ) {

        super(name);
    }

    /**
     * SpringからdataSourceを取得してテスト用コネクションを取得する<br />
     * Oracleとの接続にはスキーマもセットする。（Oracleはスキーマ設定が必要）
     * 
     * @return
     * @throws Exception
     */
    public IDatabaseConnection getConnection(boolean autoComit) throws Exception {

        DataSource ds = ( DataSource ) this.context.getBean( "dataSource" );

        Connection con = ds.getConnection();
        
        if(autoComit){
            con.setAutoCommit( true ); // autoコミットを有効に
        } else {
            con.setAutoCommit( false ); // autoコミットを無効に
        }
        

        if ( oracleFlag == true ) {

            String schema = con.getMetaData().getUserName();
            return new DatabaseConnection( con, schema );

        } else {

            return new DatabaseConnection( con );

        }

    }


    /**
     * 引数のConnectionからテスト用コネクションを取得する<br />
     * Oracleとの接続にはスキーマもセットする。（Oracleはスキーマ設定が必要）
     * @param con
     * @return
     * @throws Exception
     */
    public IDatabaseConnection getConnection( Connection con ) throws Exception {

        con.setAutoCommit( false ); // autoコミットを無効に

        if ( oracleFlag == true ) {

            String schema = con.getMetaData().getUserName();
            return new DatabaseConnection( con, schema );

        } else {

            return new DatabaseConnection( con );

        }

    }


    /**
     * 引数のConnectionでtruncateSqlを実行してDBを初期化
     * 
     */
    public void tableInit(Connection con) {

        PreparedStatement ps = null;

        try {
            
            ps = con.prepareStatement( this.truncateSql );

            ps.execute();

        } catch ( Exception e ) {

            e.printStackTrace();

        } finally {
            if ( ps != null ) {
                try {
                    ps.close();
                } catch ( Exception e ) {
                }
            }
        }

    }


    protected void logStart( String testMethodName ) {

        log.info( "Test Method Start ******************** " + classNameStr
                + "." + testMethodName + " ********************" );

    }


    protected void logEnd( String testMethodName ) {

        log.info( "Test Method End ******************** " + classNameStr + "."
                + testMethodName + " ********************" );

    }


    protected void logging( String testMethodName, String logMainStr ) {

        log.info( classNameStr + "." + testMethodName + ":" + logMainStr );

    }
    

    /**
     * テスト用ExceptionMockクラス
     * 
     * @author takeda
     *
     */
    public static class MockDataAccessException extends DataAccessException {

        private static final long serialVersionUID = 1L;

        /**
         * コンストラクタ
         */
        public MockDataAccessException() {

            super( "" );
        }
    }
}
