/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.testingframework;

import jp.co.dgic.testing.common.virtualmock.MockObjectManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import servletunit.struts.MockStrutsTestCase;

/**
 * StrutsTestCaseにdjUnitの機能を融合させたクラス
 * 
 * @author takeda
 */
public class BliDjUnitMockStrutsTestCase extends MockStrutsTestCase {

    protected Log    log          = LogFactory.getLog( this.getClass() );

    protected String classNameStr = this.getClass().getSimpleName();


    public BliDjUnitMockStrutsTestCase() {

        super();
    }


    public BliDjUnitMockStrutsTestCase( String name ) {

        super( name );

    }


    protected void setUp() throws Exception {

        super.setUp();

        MockObjectManager.initialize();
    }


    protected void tearDown() throws Exception {

        super.tearDown();

    }


    public static void addReturnNull( String className, String methodName ) {

        MockObjectManager.addReturnNull( className, methodName );
    }


    public static void addReturnValue( String className, String methodName ) {

        MockObjectManager.addReturnValue( className, methodName );
    }


    public static void addReturnValue( String className, String methodName,
            Object returnValue ) {

        MockObjectManager.addReturnValue( className, methodName, returnValue );
    }


    public static void assertArgumentPassed( String className,
            String methodName, int argumentindex, Object argumentValue ) {

        MockObjectManager.assertArgumentPassed( className, methodName,
                argumentindex, argumentValue );
    }


    public static void assertCalled( String className, String methodName ) {

        MockObjectManager.assertCalled( className, methodName );
    }


    public static void assertNotCalled( String className, String methodName ) {

        MockObjectManager.assertNotCalled( className, methodName );
    }


    public static Object getArgument( String className, String methodName,
            int argumentIndex ) {

        return MockObjectManager.getArgument( className, methodName,
                argumentIndex );
    }


    public static Object getArgument( String className, String methodName,
            int methodIndex, int argumentIndex ) {

        return MockObjectManager.getArgument( className, methodName,
                methodIndex, argumentIndex );
    }


    public static int getCallCount( String className, String methodName ) {

        return MockObjectManager.getCallCount( className, methodName );
    }


    public static Object getReturnValue( String className, String methodName ) {

        return MockObjectManager.getReturnValue( className, methodName );
    }


    public static boolean isCalled( String className, String methodName ) {

        return MockObjectManager.isCalled( className, methodName );
    }


    public static void setReturnValueAt( String className, String methodName,
            int index, Object returnValue ) {

        MockObjectManager.setReturnValueAt( className, methodName, index,
                returnValue );
    }


    public static void setReturnValueAt( String className, String methodName,
            int index ) {

        MockObjectManager.setReturnValueAt( className, methodName, index );
    }


    public static void setReturnNullAt( String className, String methodName,
            int index ) {

        MockObjectManager.setReturnNullAt( className, methodName, index );
    }


    public static void setReturnValueAtAllTimes( String className,
            String methodName, Object returnValue ) {

        MockObjectManager.setReturnValueAtAllTimes( className, methodName,
                returnValue );
    }


    public static void setReturnValueAtAllTimes( String className,
            String methodName ) {

        MockObjectManager.setReturnValueAtAllTimes( className, methodName );
    }


    public static void setReturnNullAtAllTimes( String className,
            String methodName ) {

        MockObjectManager.setReturnNullAtAllTimes( className, methodName );
    }


    public void logStart( String testMethodName ) {

        log.info( "Test Method Start ******************** " + classNameStr
                + "." + testMethodName + " ********************" );

    }


    public void logEnd( String testMethodName ) {

        log.info( "Test Method End ******************** " + classNameStr + "."
                + testMethodName + " ********************" );

    }


    public void logging( String testMethodName, String logMainStr ) {

        log.info( classNameStr + "." + testMethodName + ":" + logMainStr );

    }

}
