/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.testingframework;

import jp.co.dgic.testing.framework.DJUnitTestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * djUnitにログ出力等の機能を追加したクラス
 * 
 * @author takeda
 */
public class BliDjUnitTestCase extends DJUnitTestCase {

    protected Log    log          = LogFactory.getLog( this.getClass() );

    protected String classNameStr = this.getClass().getSimpleName();


    public BliDjUnitTestCase() {

        super();
    }


    public BliDjUnitTestCase( String name ) {

        super();
    }


    public void logStart( String testMethodName ) {

        log.info( "Test Method Start ******************** " + classNameStr
                + "." + testMethodName + " ********************" );

    }


    public void logEnd( String testMethodName ) {

        log.info( "Test Method End ******************** " + classNameStr + "."
                + testMethodName + " ********************" );

    }


    public void logging( String testMethodName, String logMainStr ) {

        log.info( classNameStr + "." + testMethodName + ":" + logMainStr );

    }

}
