class AsciiDocStyle < BloggerPost::Style
  def self.style_name
    'asciidoc'
  end

  def self.extname
    '.txt'
  end

  def entry_to_html(entry)
    html = external_convert('asciidoc -o -', entry.body.toutf8)
    html = html.sub(/<div id="header">.*?<\/div>/m, '')
    html = html.sub(/<div id="footer">.*<\/div>/m, '')
    html
  end
end

BloggerPost.register_style(AsciiDocStyle)
