class Txt2tagsStyle < BloggerPost::Style
  def self.style_name
    't2t'
  end

  def self.extname
    '.t2t'
  end

  def entry_to_html(entry)
    html = external_convert('txt2tags -t xhtml -o -', entry.body)
    html = html.sub(/<div align="center">.*?<\/div>/m, '')
    html
  end
end

BloggerPost.register_style(Txt2tagsStyle)
