require 'hikidoc'

class WikiStyle < BloggerPost::Style
  def self.style_name
    'wiki'
  end

  def self.extname
    '.wiki'
  end

  def entry_to_html(entry)
    html = HikiDoc.new(entry.body).to_html
    html = wrap_html_first_h1(html)
    html
  end
end

BloggerPost.register_style(WikiStyle)
