begin
  require 'flickr'

  class FlickrFilter < BloggerPost::Filter
    def translate(html)
      flickr = Flickr.new(@config.work_dir + 'flickr_auth_cache', '063adbe28d97be54e9237571c2dabeee', '4dfa7ef8cf14fe57')
      return html unless flickr.auth.token
      html = filter_attr(html, 'bpflickr') do |param|
        photo_id, photo_size = parse_param(param)
        photo = flickr.photos.getInfo(photo_id)
        photo_url = photo.url(photo_size)
        photopage_url = photo.urls[:photopage]
        "<a href=\"#{photopage_url}\"><img src=\"#{photo_url}\" alt=\"#{photo.title}\" title=\"#{photo.title}\"  style=\"border: none;\" /></a>"
      end
      html
    end

    private

    def parse_param(param)
      param_list = param.split(':')
      photo_id = nil
      photo_size = 'm'
      while param_list.length > 0
        element = param_list.shift
        case element
        when 'square'
          photo_size = 's'
        when 'thumbnail'
          photo_size = 't'
        when 'small'
          photo_size = 'm'
        when 'medium'
          photo_size = nil
        when 'large'
          photo_size = 'b'
        when 'original'
          photo_size = 'o'
        else
          photo_id = element
        end
      end
      [photo_id, photo_size]
    end
  end

  BloggerPost.register_filter(FlickrFilter)
rescue LoadError
  # do nothing
end
