class APTStyle < BloggerPost::Style
  def self.style_name
    'apt'
  end

  def self.extname
    '.txt'
  end

  def entry_to_html(entry)
    html = external_convert_out_in('aptconvert -enc UTF8', entry.body.toutf8)
    html
  end

  private

  def external_convert_out_in(command, src)
    tempfile_in = make_tempfile_in(src)
    tempfile_out = make_tempfile_out
    out_path = tempfile_out.path + ".xhtml"
    raise 'can not open temporary file' if File.exist?(out_path)
    `#{command} #{out_path} #{tempfile_in.path}`
    html = nil
    html = File.read(out_path)
    File.unlink(out_path)
    html
  end
end

BloggerPost.register_style(APTStyle)
