class ORGStyle < BloggerPost::Style
  def self.style_name
    'org'
  end

  def self.extname
    '.org'
  end

  def entry_to_html(entry)
    tempfile_in = make_tempfile_in("* dummy\n" + entry.body.toutf8 + "\n#+OPTIONS: num:nil toc:nil\n")
    `emacs -batch -eval '(progn (find-file "#{tempfile_in.path}")(org-mode)(org-export-as-html-batch))'`
    out_file = File.dirname(tempfile_in.path) + '/' + File.basename(tempfile_in.path, '.*') + '.html'
    html = File.read(out_file)
    File.delete(out_file)
    html = html.sub(/<p class="author">.*<\/p>/m, '')
    html = html.sub(/<p class="date">.*<\/p>/m, '')
    html = delete_all_tag(html, 'meta')
    html = delete_first_h1(html)
    html = delete_first_tag(html, 'h2')
    html
  end
end

BloggerPost.register_style(ORGStyle)
