/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.App;
import bluntirc.CTN_Conn;
import bluntirc.ChannelMemberList;
import bluntirc.ConnTreeNode;
import buffer.PackedLineWriter;
import irc.IRCChannel;
import irc.IRCChannelMember;
import irc.IRCChannelName;
import irc.IRCConnection;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CTN_Chan
extends ConnTreeNode {
    public IRCChannel chan;
    public ChannelMemberList userlist = new ChannelMemberList();
    static ImageIcon icon_chan = Util.GetImageIconFromJAR("images/chan1.gif");
    static ImageIcon icon_chanM = Util.GetImageIconFromJAR("images/chan2.gif");
    static ImageIcon icon_chanD = Util.GetImageIconFromJAR("images/chan3.gif");
    boolean hasMidoku = false;

    public CTN_Chan getChannelNode() {
        return this;
    }

    public CTN_Conn getConnNode() {
        return (CTN_Conn)this.getParent();
    }

    public IRCChannel GetChannel() {
        return this.chan;
    }

    public IRCChannel getChannel() {
        return this.chan;
    }

    public String GetCaption() {
        return this.chan.getShortName();
    }

    public ChannelMemberList getUserList() {
        return this.userlist;
    }

    public ImageIcon getImageIcon() {
        return !this.chan.isInMyself() ? icon_chanD : (this.hasMidoku ? icon_chanM : icon_chan);
    }

    public void addMidoku(PackedLineWriter line, boolean noMidokuCheck) {
        super.addMidoku(line);
        if (!this.hasMidoku && !noMidokuCheck && App.getSelected() != this) {
            this.hasMidoku = true;
            App.redrawTreeView(this);
        }
    }

    public void OnSelect() {
        this.hasMidoku = false;
        App.selectTreeView(this);
    }

    public String getPopupName() {
        return "popup-channel";
    }

    public int getListLevel() {
        return 2;
    }

    public String getTitle() {
        return this.getConnNode().GetCaption() + " " + this.GetCaption() + " " + this.chan.getChannelMode() + " " + this.chan.getTopic();
    }

    public String getBufferInfo() {
        int minv;
        int minc = this.chan.getUserCount();
        if (minc != (minv = this.userlist.getRowCount())) {
            App.Log("\u5185\u90e8\u3067\u306e\u30e6\u30fc\u30b6\u306e\u7ba1\u7406\u304c\u304a\u304b\u3057\u3044\u3067\u3059 IRCChannel=" + minc + " UserTableList=" + minv);
            Thread.dumpStack();
        }
        return super.getBufferInfo() + " " + Integer.toString(this.chan.getUserCount()) + "\u4eba";
    }

    public void checkAutoJoin() {
        if (this.property.getBoolean("AutoJoin", false)) {
            this.OnMenuJoin();
        }
    }

    public void OnDoubleClick(MouseEvent e) {
        IRCConnection conn = this.getConnNode().conn;
        if (conn.isConnected()) {
            this.OnMenuJoin();
            return;
        }
        this.getConnNode().OnDoubleClick(e);
        Vector<Object> v = new Vector<Object>();
        v.add("JOIN");
        v.add(this.chan.getCName().getJoinNameBytes());
        String pass = this.property.getString("Password");
        if (pass != null && pass.length() > 0) {
            v.add(pass);
        }
        conn.addCommandOnAuthorized(conn.encodeList(v));
    }

    public void setDefaultOption() {
        this.property.setDefaultString("Password", "");
        this.property.setDefaultBoolean("AutoJoin", false);
        this.property.setDefaultBoolean("RejoinOnKicked", false);
        this.property.setDefaultBoolean("AutoWho", false);
        this.property.setDefaultBoolean("AutoModeQuery", true);
    }

    public Object getPropertyExtra() {
        return this.chan;
    }

    public void onHashSave() {
    }

    public void onHashLoad() {
    }

    public void onPropertyChanged(String name, Object value) {
    }

    public void OnMenuJoin() {
        Vector<Object> v = new Vector<Object>();
        v.add("JOIN");
        v.add(this.chan.getCName().getJoinNameBytes());
        String pass = this.property.getString("Password");
        if (pass != null && pass.length() > 0) {
            v.add(pass);
        }
        this.getConnNode().conn.SendToServer(v);
    }

    public void OnMenuPart(String msg) {
        Vector<Object> v = new Vector<Object>();
        v.add("PART");
        v.add(this.chan.getCName().getRawBytes());
        v.add(Util.toJIS(msg));
        this.getConnNode().conn.SendToServer(v);
    }

    public void OnMenuTopic(String msg) {
        Vector<Object> v = new Vector<Object>();
        v.add("TOPIC");
        v.add(this.chan.getCName().getRawBytes());
        v.add(Util.toJIS(msg));
        this.getConnNode().conn.SendToServer(v);
    }

    public void addOp(IRCChannelMember u, String op) {
        Vector<Object> v = new Vector<Object>();
        v.add("MODE");
        v.add(this.chan.getCName().getRawBytes());
        v.add(op);
        v.add(u.getUser().getNickBytes());
        this.getConnNode().conn.SendToServer(v);
    }

    public static ConnTreeNode createNode(ConnTreeNode parent, List param) {
        String name = (String)param.get(0);
        IRCChannel chan = ((CTN_Conn)parent).conn.FindChannel(IRCChannelName.unescape(name), true);
        return (ConnTreeNode)chan.Extra;
    }

    public static ConnTreeNode createByInitIRCChannel(ConnTreeNode p, IRCChannel chan) {
        return new CTN_Chan(p, chan);
    }

    private CTN_Chan(ConnTreeNode p, IRCChannel chan) {
        super(null);
        this.chan = chan;
        CTN_Conn parent = (CTN_Conn)p;
        chan.Extra = this;
        parent.insertNodeInto(this);
        this.setDefaultOption();
    }

    public List getCreateParam() {
        LinkedList<String> l = new LinkedList<String>();
        l.add(this.GetChannel().getEscapedName());
        return l;
    }

    public void PreRemove() {
        CTN_Conn conn_node = this.getConnNode();
        if (conn_node == null) {
            return;
        }
        IRCConnection conn = conn_node.conn;
        if (conn == null) {
            return;
        }
        conn.RemoveChannel(this.chan);
    }
}

