/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.SelectorRun;
import base.Util;
import bdate.BuildDate;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ConnTreeNode;
import bluntirc.PrintFormat;
import bluntirc.PrintFormatMacro;
import bluntirc.PrintFormatToTextSpan;
import bluntirc.djava.HookManager;
import bluntirc.djava.ScriptItem;
import buffer.PackedLineWriter;
import hook.IRCMessageRewrite1;
import hook.IRCMessageRewrite2;
import irc.IRCChannel;
import irc.IRCChannelMember;
import irc.IRCConnection;
import irc.IRCConnectionListener;
import irc.IRCLogContext;
import irc.IRCMessage;
import irc.IRCUser;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimeZone;

public class ConnectionListener
implements IRCConnectionListener {
    public static File logdir = new File("log");

    public SelectorRun getSelector() {
        return App.selector;
    }

    public IRCMessage rewriteIRCMessage1(IRCMessage m) {
        Iterator it = App.hook_manager.getHookList();
        while (it.hasNext()) {
            ScriptItem si = (ScriptItem)it.next();
            Object plugin = si.getPlugin();
            if (!(plugin instanceof IRCMessageRewrite1)) continue;
            try {
                m = ((IRCMessageRewrite1)plugin).rewriteIRCMessage1(m);
            }
            catch (Throwable e) {
                HookManager.parseScriptError(si.getName(), e);
            }
        }
        return m;
    }

    public IRCMessage rewriteIRCMessage2(IRCMessage m) {
        Iterator it = App.hook_manager.getHookList();
        while (it.hasNext()) {
            ScriptItem si = (ScriptItem)it.next();
            Object plugin = si.getPlugin();
            if (!(plugin instanceof IRCMessageRewrite2)) continue;
            try {
                m = ((IRCMessageRewrite2)plugin).rewriteIRCMessage2(m);
            }
            catch (Throwable e) {
                HookManager.parseScriptError(si.getName(), e);
            }
        }
        return m;
    }

    public TimeZone getTimeZone(IRCConnection conn) {
        Object o = ((CTN_Conn)conn.Extra).property.get("TimeZoneObject");
        if (o instanceof TimeZone) {
            return (TimeZone)o;
        }
        TimeZone tz = TimeZone.getTimeZone(((CTN_Conn)conn.Extra).property.setDefaultString("TimeZone", "JST"));
        ((CTN_Conn)conn.Extra).property.set("TimeZoneObject", (Object)tz);
        return tz;
    }

    public String getServerHost(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("Server");
    }

    public int getServerPort(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultInt("Port", 60);
    }

    public int getSoTimeout(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultInt("SoTimeout", 0);
    }

    public String getLocalHost(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultString("SourceHost", "");
    }

    public int getLocalPort(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultInt("SourcePort", 0);
    }

    public String getNickName(IRCConnection conn, boolean isFirst) {
        return ((CTN_Conn)conn.Extra).getNickName(isFirst);
    }

    public String getPassword(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("Password");
    }

    public String getUserName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("UserName");
    }

    public String getRealName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("RealName");
    }

    public String getMyUserMode(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("UserMode", "");
    }

    public String getConnectionName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).getName();
    }

    public static String system_property(String key) {
        return key + "=" + System.getProperty(key) + " ";
    }

    public String getCTCPReplyVersion(IRCMessage m) {
        return App.config_AppName + " http://tate.undef.jp/pub/BluntIRC/BluntIRC.html " + ":build " + BuildDate.getVersion() + ":" + ConnectionListener.system_property("java.runtime.name") + ConnectionListener.system_property("java.runtime.version") + ConnectionListener.system_property("os.arch") + ConnectionListener.system_property("os.name") + ConnectionListener.system_property("os.version") + ConnectionListener.system_property("sun.os.patch.level") + ConnectionListener.system_property("user.language") + ConnectionListener.system_property("sun.arch.data.model");
    }

    public String getCTCPReplyFinger(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyFinger", "\u8a2d\u5b9a\u306a\u3057");
    }

    public String getCTCPReplyUserInfo(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyUserInfo", "\u8a2d\u5b9a\u306a\u3057");
    }

    public boolean isAutoReconnect(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("AutoReconnect", false);
    }

    public boolean isDumpRecvLine(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvLine", false);
    }

    public boolean isDumpRecvCTCP(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvCTCP", true);
    }

    public boolean isDontParseCTCP(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("DontParseCTCP", false);
    }

    public boolean isQuoteAllParam(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteAllParam", false);
    }

    public boolean isQuoteSpace(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpace", false);
    }

    public boolean isQuoteSpaceAtCTCPArg(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpaceAtCTCPArg", false);
    }

    public boolean isQuote001(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("Quote001", true);
    }

    public void onChannelKicked(IRCMessage m) {
        CTN_Chan node = (CTN_Chan)((IRCChannel)m.target.get((int)0)).Extra;
        if (node.property.setDefaultBoolean("RejoinOnKicked", false)) {
            node.OnMenuJoin();
        }
    }

    public int getCTCPSendCueTimeExpire(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("SendCueTimeExpire", 60);
    }

    public int getCTCPSendCueLimitInTime(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueLimitInTime", 20);
    }

    public int getCTCPSendCueMaxInLine(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueMaxInLine", 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnLogEvent(IRCMessage m, Object to, IRCLogContext buffer_id) {
        PrintFormat pf;
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        String fname = null;
        if (buffer_id.isLogFile()) {
            if (logdir == null) {
                return;
            }
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "LogFileName");
            if (pf == null) {
                App.Log("PrintFormat.conf \u306e\u300c" + buffer_id.toString() + "\u300d\u306bLogFileName\u306e\u6307\u5b9a\u304c\u306a\u3044");
                return;
            }
            fname = PrintFormatToTextSpan.getText(m, to, pf, false);
            if (fname == null) {
                return;
            }
        }
        if ((pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), m.cmd)) == null && 0 == m.cmd.indexOf("On")) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "OnOther");
        }
        if (pf == null && 0 == m.cmd.indexOf("CTCP")) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "OtherCTCP");
        }
        if (pf == null) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "other");
        }
        if (pf == null) {
            pf = new PrintFormat();
            pf.macro.add("!");
            pf.macro.add(PrintFormatMacro.getNormalName(m.log_from));
            pf.macro.add(" ");
            pf.macro.add(m.cmd);
            pf.macro.add(" ");
            pf.macro.add(m.params_str);
        }
        if (!buffer_id.isLogFile()) {
            PackedLineWriter line = PrintFormatToTextSpan.getTextLine(m, to, pf, true, App.style_manager);
            if (line != null) {
                if (buffer_id == IRCLogContext.LB_All) {
                    ConnTreeNode node;
                    if (App.root_property.getBoolean("AllLog_ChocoaStingy", false) && (node = App.getSelected()) != null) {
                        if (to instanceof IRCConnection && node instanceof CTN_Conn && ((CTN_Conn)node).conn == to) {
                            return;
                        }
                        if (to instanceof IRCChannel && node instanceof CTN_Chan && ((CTN_Chan)node).chan == to) {
                            return;
                        }
                        if (to instanceof IRCChannel && node instanceof CTN_Priv && ((CTN_Priv)node).chan == to) {
                            return;
                        }
                    }
                    App.getApp();
                    App.log_all.doc.addText((Component)App.main_window, line);
                } else if (buffer_id == IRCLogContext.LB_Dump) {
                    App.getApp().addMidoku(line);
                } else if (buffer_id == IRCLogContext.LB_Conn) {
                    connNode.addMidoku(line);
                } else if (buffer_id == IRCLogContext.LB_Chan) {
                    ((CTN_Chan)((IRCChannel)to).Extra).addMidoku(line, pf.NoCountMidoku);
                } else if (buffer_id == IRCLogContext.LB_Priv) {
                    ((CTN_Priv)((IRCChannel)to).Extra).addMidoku(line, pf.NoCountMidoku);
                }
            }
            return;
        }
        fname = Util.EscapeForFile(fname);
        String line = PrintFormatToTextSpan.getText(m, to, pf, true);
        if (line == null) {
            return;
        }
        File f = logdir;
        try {
            f = new File(f, fname);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = new File(f, m.getDateStr() + "." + App.root_property.getString("LogFileEncoding") + ".txt");
            FileOutputStream fos = new FileOutputStream(f.getAbsolutePath(), true);
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, App.root_property.getString("LogFileEncoding"));
                out.write(line, 0, line.length());
                if (App.root_property.getBoolean("LogCRLF", false)) {
                    out.write(13);
                }
                out.write(10);
                out.flush();
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                fos.flush();
                fos.close();
                throw throwable;
            }
            fos.flush();
            fos.close();
            return;
        }
        catch (SecurityException e) {
            App.Log(f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3\u306b\u3088\u3063\u3066\u62d2\u5426\u3055\u308c\u305f\u3002" + e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u6307\u5b9a\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u540d" + f.getAbsolutePath() + "\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u306a\u3044\u3002" + e.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb" + f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306b\u6307\u5b9a\u3057\u305f\u6587\u5b57\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0" + App.root_property.getString("LogFileEncoding") + "\u306f\u3053\u306e\u30b7\u30b9\u30c6\u30e0\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u3002" + e.getLocalizedMessage());
        }
        catch (IOException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb" + f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u5931\u6557\u3057\u305f\u3002" + e.getLocalizedMessage());
        }
        logdir = null;
        StringBuffer stringBuffer = new StringBuffer().append("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306f\u8a2d\u5b9a\u3092\u5909\u66f4\u3057\u3066");
        App.getApp();
        App.Log(stringBuffer.append(App.config_AppName).append("\u3092\u518d\u8d77\u52d5\u3059\u308b\u307e\u3067\u306f\u7121\u52b9\u306b\u306a\u308b\u3002").toString());
    }

    public void OnConnectRequest(IRCConnection conn) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void OnConnectAuthorized(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void OnConnectMOTDEnd(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        String mode = m.conn.getListener().getMyUserMode(m);
        if (mode != null) {
            LinkedList<Object> v = new LinkedList<Object>();
            v.add("MODE");
            v.add(m.conn.myself.getNickBytes());
            v.add(mode);
            m.conn.SendToServer(v);
        }
        Iterator it = connNode.getChannelNodes().iterator();
        while (it.hasNext()) {
            CTN_Chan node = (CTN_Chan)it.next();
            node.checkAutoJoin();
        }
    }

    public void OnDisconnect(IRCConnection conn) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void initIRCChannel(IRCConnection conn, IRCChannel chan) {
        if (chan.Extra == null) {
            chan.Extra = chan.isChannel() ? CTN_Chan.createByInitIRCChannel((CTN_Conn)conn.Extra, chan) : CTN_Priv.createByInitIRCChannel((CTN_Conn)conn.Extra, chan);
        }
    }

    public void RemoveChannel(IRCConnection conn, IRCChannel chan) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.logger.warning("CTN_Conn.RemoveChannel");
    }

    public void ChangeChannelJoin(IRCConnection conn, IRCChannel c, boolean is_in) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        this.initIRCChannel(conn, c);
        CTN_Chan node = (CTN_Chan)c.Extra;
        App.redrawTreeView(node);
        if (!is_in) {
            if (c.isChannel()) {
                c.setChannelModeString("-");
            }
        } else if (c.isChannel()) {
            LinkedList<Object> v;
            if (node.property.getBoolean("AutoWho", true)) {
                v = new LinkedList<Object>();
                v.add("WHO");
                v.add(c.getCName().getRawBytes());
                conn.SendToServer(v);
            }
            if (node.property.getBoolean("AutoModeQuery", true)) {
                v = new LinkedList();
                v.add("MODE");
                v.add(c.getCName().getRawBytes());
                conn.SendToServer(v);
            }
        }
        if (App.getSelected() == connNode) {
            App.getApp().updateTopic();
        }
        App.redrawTreeView(connNode);
    }

    public void SetChannelMode(IRCMessage m, IRCChannel c) {
        App.getApp().updateTopic();
    }

    public void ChangeNickMyself(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        App.getApp().updateTopic();
    }

    public void ChangeUserInfo(IRCConnection conn, IRCChannel c, byte[] fromNick, IRCChannelMember to) {
        this.initIRCChannel(conn, c);
        if (c.isChannel()) {
            ((CTN_Chan)c.Extra).userlist.ChangeUserInfo(fromNick, to);
        } else {
            App.updateBufferListItem((CTN_Priv)c.Extra);
        }
    }

    public void RemoveUserList(IRCConnection conn, IRCChannel c, IRCChannelMember who) {
        this.initIRCChannel(conn, c);
        ((CTN_Chan)c.Extra).userlist.RemoveUserList(who);
        if (App.getSelected() == c.Extra) {
            App.getApp().updateTopic();
        }
    }

    public void OnWhoReply(IRCMessage m, IRCChannel c, IRCUser who) {
        if (c != null) {
            this.initIRCChannel(m.conn, c);
            ((CTN_Chan)c.Extra).userlist.setWhoReply(who);
        }
    }

    public void onChangePrefix(IRCConnection conn, IRCUser who, int type) {
        CTN_Chan node = App.getSelectedChannel();
        if (node != null) {
            node.userlist.setWhoReply(who);
        }
        if (type >= 2) {
            App.Log(who.getPrefixStr() + " \u306eprefix\u306f\u4eca\u307e\u3067\u3068\u7570\u306a\u308a\u307e\u3059 " + type);
        }
    }

    public void ChangeTopic(IRCMessage m, IRCChannel c) {
        if (App.getSelectedChannel() == c.Extra) {
            App.getApp().updateTopic();
        }
    }

    public void checkCTCPPingReply(IRCMessage ctcp) {
        try {
            long old_time = Long.parseLong(ctcp.log_msg, 10);
            long now = ctcp.time.getTime().getTime();
            long diff = now - old_time;
            if (diff >= 0L) {
                String low = Long.toString(diff % 1000L + 1000L);
                String s = Long.toString(diff / 1000L) + "." + low.substring(low.length() - 3);
                ctcp.log_msg = ctcp.from.getShortName() + " \u306e\u30e9\u30b0\u30bf\u30a4\u30e0\u306f " + s + " \u79d2\u3067\u3059\u3002";
            }
        }
        catch (NumberFormatException e) {}
    }

    public void checkDCC(IRCMessage ctcp) {
    }
}

