/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.MyStreamTokenizer;
import base.Util;
import bluntirc.App;
import bluntirc.RefAction;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuConf
implements MenuListener,
PopupMenuListener {
    LinkedList menus;
    HashMap popup_cache;
    HashMap action_to_stroke = new HashMap();
    HashMap stroke_to_menu = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        String fname = "menu.conf";
        try {
            InputStreamReader r = new InputStreamReader(Util.OpenFile(fname), "UTF-8");
            try {
                try {
                    MyStreamTokenizer in = new MyStreamTokenizer(r, fname, false);
                    this.menus = MenuConf.readMenu(in);
                    this.action_to_stroke.clear();
                    this.stroke_to_menu.clear();
                    this.popup_cache = new HashMap();
                    App.Log(fname + "\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                    Object var5_7 = null;
                }
                catch (IOException e) {
                    App.Log(fname + "\u3092\u8aad\u3081\u307e\u305b\u3093:" + e.getMessage());
                    Object var5_8 = null;
                    ((Reader)r).close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                ((Reader)r).close();
                throw throwable;
            }
            ((Reader)r).close();
            return;
        }
        catch (FileNotFoundException e) {
            App.Log(e.getMessage());
            return;
        }
        catch (IOException e) {
            App.Log(fname + ":" + e.toString() + " " + e.getMessage());
            return;
        }
    }

    protected static LinkedList readMenu(MyStreamTokenizer in) throws IOException {
        LinkedList<HashMap> result = new LinkedList<HashMap>();
        while (true) {
            try {
                in.skipToStartOfStatement();
                if (in.ttype == -1) break;
                if (in.ttype == -3 && in.sval.equals("end")) {
                    in.nextToken();
                    break;
                }
                HashMap node = in.readOptions("\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a", true);
                if (null != node.get("menu")) {
                    node.put("=submenu", MenuConf.readMenu(in));
                }
                result.addLast(node);
            }
            catch (ParseException e) {
                App.Log(in.fname + " " + in.lineno() + "\u884c: " + e.getMessage());
                in.skipToEndOfStatement();
            }
        }
        return result;
    }

    static HashMap findMenuInfo(LinkedList menu, String key) {
        Iterator it = menu.iterator();
        while (it.hasNext()) {
            HashMap node = (HashMap)it.next();
            Object value = node.get("menu");
            if (value == null) continue;
            if (key.equals((String)value)) {
                return node;
            }
            if ((node = MenuConf.findMenuInfo((LinkedList)node.get("=submenu"), key)) == null) continue;
            return node;
        }
        return null;
    }

    HashMap findMenuInfo(String key) {
        HashMap node = MenuConf.findMenuInfo(this.menus, key);
        if (node == null) {
            App.Log("menu.conf \u306b menu=" + key + "\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        return node;
    }

    public void setJMenuBar(JFrame window) {
        HashMap node = this.findMenuInfo("MenuBar");
        if (node == null) {
            return;
        }
        JMenuBar menu = window.getJMenuBar();
        if (menu == null) {
            menu = new JMenuBar();
            Iterator it = ((LinkedList)node.get("=submenu")).iterator();
            while (it.hasNext()) {
                HashMap item = (HashMap)it.next();
                if (null == item.get("menu")) continue;
                menu.add(this.createJMenu(item));
            }
            menu.setBorder(null);
            window.setJMenuBar(menu);
            return;
        }
        menu.setSelected(null);
        LinkedList<JMenu> tm = new LinkedList<JMenu>();
        Iterator it = ((LinkedList)node.get("=submenu")).iterator();
        while (it.hasNext()) {
            HashMap item = (HashMap)it.next();
            if (null == item.get("menu")) continue;
            JMenu m = this.createJMenu(item);
            tm.addLast(m);
        }
        int i = 0;
        while (i < menu.getMenuCount()) {
            JMenu old = menu.getMenu(i);
            old.setText("");
            old.removeAll();
            old.setMnemonic(-1);
            old.setEnabled(false);
            ++i;
        }
        int i2 = 0;
        while (i2 < menu.getMenuCount()) {
            JMenu old = menu.getMenu(i2);
            if (tm.size() > 0) {
                JMenu neo = (JMenu)tm.removeFirst();
                while (neo.getItemCount() > 0) {
                    JMenuItem item = neo.getItem(0);
                    neo.remove(0);
                    if (item == null) {
                        old.addSeparator();
                        continue;
                    }
                    old.add(item);
                }
                old.setText(neo.getText());
                int c = neo.getMnemonic();
                old.setMnemonic(c);
                old.setEnabled(neo.isEnabled());
            }
            ++i2;
        }
        while (tm.size() > 0) {
            menu.add((JMenu)tm.removeFirst());
        }
    }

    public JPopupMenu getMenu(String name) {
        JPopupMenu pm = (JPopupMenu)this.popup_cache.get(name);
        if (pm != null) {
            return pm;
        }
        HashMap node = this.findMenuInfo(name);
        if (node == null) {
            return null;
        }
        pm = new JPopupMenu(name){

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (b) {
                    this.setSelected(null);
                }
            }
        };
        pm.addPopupMenuListener(this);
        Iterator it = ((LinkedList)node.get("=submenu")).iterator();
        while (it.hasNext()) {
            HashMap item = (HashMap)it.next();
            if (null != item.get("menu")) {
                pm.add(this.createJMenu(item));
            }
            if (null != item.get("separator")) {
                pm.addSeparator();
            }
            if (null == item.get("action")) continue;
            pm.add(this.createJMenuItem(item));
        }
        this.popup_cache.put(name, pm);
        return pm;
    }

    JMenu createJMenu(HashMap node) {
        JMenu menu = null;
        if (node.get("secret") != null) {
            menu = new JMenu("");
            menu.setEnabled(false);
        } else {
            Object o = node.get("caption");
            if (o == null) {
                o = node.get("menu");
            }
            menu = new JMenu((String)o);
            o = node.get("mnemonic");
            if (o != null) {
                menu.setMnemonic(((String)o).charAt(0));
            }
        }
        menu.addMenuListener(this);
        if (node.get("invoker") != null) {
            menu.putClientProperty("action_invoker", node.get("invoker"));
        }
        Iterator it = ((LinkedList)node.get("=submenu")).iterator();
        while (it.hasNext()) {
            HashMap item = (HashMap)it.next();
            if (null != item.get("menu")) {
                menu.add(this.createJMenu(item));
            }
            if (null != item.get("separator")) {
                menu.addSeparator();
            }
            if (null == item.get("action")) continue;
            menu.add(this.createJMenuItem(item));
        }
        return menu;
    }

    public KeyStroke findAccelerator(String action_name) {
        return (KeyStroke)this.action_to_stroke.get(action_name);
    }

    public JMenuItem findMenuItem(KeyStroke stroke) {
        return (JMenuItem)this.stroke_to_menu.get(stroke);
    }

    JMenuItem createJMenuItem(HashMap node) {
        String action_name = (String)node.get("action");
        if (action_name == null || action_name.length() <= 1) {
            return new JMenuItem("action is not specified");
        }
        Action action = App.action_manager.find(action_name);
        String name = (String)node.get("caption");
        if (name == null && action != null) {
            name = (String)action.getValue("Name");
        }
        if (name == null) {
            name = action_name;
        }
        JMenuItem menu = new JMenuItem(new RefAction(action, action_name));
        menu.setText(name);
        Object o = node.get("accelerator");
        if (o != null) {
            KeyStroke k = KeyStroke.getKeyStroke((String)o);
            if (k != null) {
                menu.setAccelerator(k);
                this.stroke_to_menu.put(k, menu);
                this.action_to_stroke.put(action_name, k);
            } else {
                App.Log((String)o + "\u306f\u6709\u52b9\u306a\u30ad\u30fc\u30b9\u30c8\u30ed\u30fc\u30af\u6307\u5b9a\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
        }
        if ((o = node.get("mnemonic")) != null) {
            menu.setMnemonic(((String)o).charAt(0));
        }
        if ((o = node.get("command")) != null) {
            menu.setActionCommand((String)o);
        }
        return menu;
    }

    public void checkMenu(MenuElement[] me_ary, boolean rec) {
        int i = 0;
        while (i < me_ary.length) {
            JComponent m;
            if (me_ary[i] instanceof JPopupMenu) {
                m = (JPopupMenu)me_ary[i];
                this.checkMenu(m.getSubElements(), false);
            } else if (me_ary[i] instanceof JMenu) {
                m = (JMenu)me_ary[i];
            } else if (me_ary[i] instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)me_ary[i];
                if (mi != null) {
                    boolean b = false;
                    Action a = mi.getAction();
                    if (a != null) {
                        b = a.isEnabled();
                    }
                    mi.setEnabled(b);
                }
            } else if (me_ary[i] != null) {
                App.Log(" MenuElement is " + me_ary[i].getClass().getName());
            }
            ++i;
        }
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        App.recordPreFocus("menuSelected ");
        JMenu m = (JMenu)e.getSource();
        this.checkMenu(m.getSubElements()[0].getSubElements(), false);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        App.recordPreFocus("popupMenuWillBecomeVisible ");
        this.checkMenu(((JPopupMenu)e.getSource()).getSubElements(), false);
    }

    public void showPopupMenu(MouseEvent e, String menu_name) {
        this.showPopupMenu(e, menu_name, null);
    }

    public void showPopupMenu(MouseEvent e, String menu_name, PopupMenuListener listener) {
        JPopupMenu pm = this.getMenu(menu_name);
        if (pm == null) {
            return;
        }
        if (listener != null) {
            pm.addPopupMenuListener(listener);
        }
        Point screenStart = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(screenStart, e.getComponent());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = e.getX() + 1;
        int y = e.getY() + 1;
        int w = pm.getWidth();
        int h = pm.getHeight();
        if (x > screenStart.x + screenSize.width - w) {
            x = screenStart.x + screenSize.width - w;
        }
        if (y > screenStart.y + screenSize.height - h) {
            y = screenStart.y + screenSize.height - h;
        }
        if (x < screenStart.x) {
            x = screenStart.x;
        }
        if (y < screenStart.y) {
            y = screenStart.y;
        }
        pm.show(e.getComponent(), x, y);
    }
}

