/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.LogLineInfo;
import buffer.PackedLineReader;
import buffer.SpanSizeDetail;
import buffer.StyleID;
import gui.Color4;
import gui.FontInfo2;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

class SpanMetrics {
    PackedLineReader tsi;
    int length;
    Font font;
    static Stroke normal_stroke = new BasicStroke(1.0f);
    static Stroke hover_stroke = new BasicStroke(1.0f, 1, 1, 3.0f, new float[]{2.0f, 4.0f}, 1.0f);
    static Composite normal_composite = AlphaComposite.getInstance(2);
    static Composite hover_composite = AlphaComposite.getInstance(3, 0.3f);
    StyleID sid;
    FontMetrics lastFontMetrics = null;

    public SpanMetrics(PackedLineReader tsi, StyleID sid) {
        this.tsi = tsi;
        this.length = tsi.text_span_length;
        this.sid = sid;
        this.font = sid.getFont(tsi);
    }

    String getText() {
        return this.tsi.getSpanText();
    }

    int getSubstringWidth(Object o, int start, int end) {
        if (o instanceof Graphics) {
            return ((Graphics)o).getFontMetrics(this.font).charsWidth(this.tsi.text_bulk, this.tsi.text_offset + start, end - start);
        }
        if (o instanceof Component) {
            return ((Component)o).getFontMetrics(this.font).charsWidth(this.tsi.text_bulk, this.tsi.text_offset + start, end - start);
        }
        return end - start;
    }

    SpanSizeDetail calcSizeDetail(Object o, int start, int end) {
        if (this.font == null) {
            System.err.println("calcSizeDetail: no font");
        }
        FontMetrics fm = null;
        if (o instanceof Component) {
            fm = ((Component)o).getFontMetrics(this.font);
        }
        if (o instanceof Graphics) {
            fm = ((Graphics)o).getFontMetrics(this.font);
        }
        if (fm != null) {
            this.lastFontMetrics = fm;
        } else if (this.lastFontMetrics != null) {
            fm = this.lastFontMetrics;
        } else {
            SpanSizeDetail lss = new SpanSizeDetail();
            lss.Ascent = 1;
            lss.Descent = 1;
            lss.Leading = 1;
            lss.width = end - start;
            return lss;
        }
        FontInfo2 fi = this.sid.getBaseStyle(this.tsi.baseid);
        SpanSizeDetail lss = new SpanSizeDetail();
        lss.Ascent = fm.getAscent() + (Integer)fi.get(8);
        lss.Descent = fm.getDescent() + (Integer)fi.get(9);
        lss.Leading = fm.getLeading() + (Integer)fi.get(10);
        if (lss.Ascent <= 0) {
            lss.Ascent = 1;
        }
        if (lss.Descent <= 0) {
            lss.Descent = 1;
        }
        if (lss.Leading <= 0) {
            lss.Leading = 1;
        }
        lss.width = fm.charsWidth(this.tsi.text_bulk, this.tsi.text_offset + start, end - start);
        return lss;
    }

    int calcMojisu(Object c, int start, int width) {
        int w;
        int min = start;
        int max = this.length;
        while (max - min > 2) {
            int mid = max + min >> 1;
            w = this.getSubstringWidth(c, start, mid);
            if (w == width) {
                return mid - start;
            }
            if (w < width) {
                min = mid;
                continue;
            }
            max = mid - 1;
        }
        int i = max;
        while (i >= start) {
            w = this.getSubstringWidth(c, start, i);
            if (w <= width) {
                return i - start;
            }
            --i;
        }
        return 0;
    }

    int calcOffset(Object c, int start, int width) {
        return start + this.calcMojisu(c, start, width);
    }

    public int draw(Graphics g, int x, int y, LogLineInfo line, int start, int end, int style, StyleID sid) {
        int yy;
        Color color;
        boolean selected;
        if (end <= start || end > this.length || start < 0) {
            return 0;
        }
        int str_width = this.getSubstringWidth(g, start, end);
        int font_style = sid.getFontStyle(this.tsi);
        Color4 c4 = sid.getColor(this.tsi);
        boolean rev = 0 != (font_style & 8);
        boolean bl = selected = style == 2;
        Color color2 = rev ? (selected ? c4.fg2 : c4.fg) : (color = selected ? c4.bg2 : c4.bg);
        if (color != null) {
            g.setColor(color);
            g.fillRect(x, y, str_width, line.height);
        }
        Color color3 = rev ? (selected ? c4.bg2 : c4.bg) : (color = selected ? c4.fg2 : c4.fg);
        if (color == null) {
            color = rev ? (selected ? Color.black : Color.white) : (selected ? Color.white : Color.black);
        }
        g.setColor(color);
        if (style == 1 && null == sid.getBaseStyle(this.tsi.baseid).get(4)) {
            ((Graphics2D)g).setComposite(hover_composite);
            g.drawRect(x - 2, y, str_width + 3, line.height);
            ((Graphics2D)g).setComposite(normal_composite);
        }
        g.setFont(this.font);
        g.drawChars(this.tsi.text_bulk, this.tsi.text_offset + start, end - start, x, y + line.baseline);
        if (0 != (font_style & 4)) {
            yy = y + (line.height - 1);
            g.drawLine(x, yy, x + str_width, yy);
        }
        if (0 != (font_style & 0x10)) {
            yy = y + line.baseline - (g.getFontMetrics().getAscent() >> 1);
            g.drawLine(x, yy, x + str_width, yy);
        }
        return str_width;
    }
}

