/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class MyTableUI
extends BasicTableUI {
    MyTableUI() {
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            int row = rMin;
            while (row <= rMax) {
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                ++row;
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                int column = cMin;
                while (column <= cMax) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                    ++column;
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                int column = cMin;
                while (column < cMax) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                    ++column;
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int row = rMin;
            while (row <= rMax) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                int column = cMin;
                while (column <= cMax) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                    ++column;
                }
                ++row;
            }
        } else {
            int row = rMin;
            while (row <= rMax) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                int column = cMin + 1;
                while (column <= cMax) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    ++column;
                }
                ++row;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        int row = rMin;
        while (row <= rMax) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (this.table.getShowHorizontalLines()) {
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                g.drawLine(x1, y2, x2, y2);
            }
            ++row;
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }
}

