/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.IRCChannelMember;
import irc.IRCChannelNameOrPrefix;
import java.util.Comparator;

public class IRCUser
implements Comparable,
IRCChannelNameOrPrefix,
Comparator {
    protected byte[] NickBytes;
    protected byte[] AfterNickBytes;
    protected String NickStr;
    protected String AfterNickStr;
    protected String PrefixStr;
    protected String Server;
    protected int HopCount = -2;
    protected String HomeGone;
    protected String RealName;

    private IRCUser(byte[] src) {
        this.set(src);
    }

    public static IRCUser createByIRCConnection(byte[] prefix) {
        return new IRCUser(prefix);
    }

    public static IRCUser createComparator() {
        return new IRCUser("Comparator".getBytes());
    }

    public byte[] getNickBytes() {
        return this.NickBytes;
    }

    public byte[] getAfterNickBytes() {
        return this.AfterNickBytes;
    }

    public String getName() {
        return this.NickStr;
    }

    public String getNick() {
        return this.NickStr;
    }

    public String getAfterNickStr() {
        return this.AfterNickStr;
    }

    public String getPrefixStr() {
        return this.PrefixStr;
    }

    public String getShortName() {
        return this.NickStr;
    }

    public String getPrintableName() {
        return this.NickStr;
    }

    public String getEscapedName() {
        return this.PrefixStr;
    }

    public byte[] getRawBytes() {
        return this.NickBytes;
    }

    public byte[] getUserNameBytes() {
        int i;
        if (this.AfterNickBytes != null && (i = Util.ByteIndexOf(this.AfterNickBytes, '@')) > 0 && i <= this.AfterNickBytes.length) {
            return Util.ByteSubString(this.AfterNickBytes, 1, i);
        }
        return new byte[0];
    }

    public byte[] getHostBytes() {
        int i;
        if (this.AfterNickBytes != null && (i = Util.ByteIndexOf(this.AfterNickBytes, '@')) > 0 && i < this.AfterNickBytes.length) {
            return Util.ByteSubString(this.AfterNickBytes, i + 1, this.AfterNickBytes.length);
        }
        return new byte[0];
    }

    public void set(byte[] src) {
        int i = Util.ByteIndexOf(src, '!');
        if (i == -1) {
            i = src.length;
        }
        this.NickBytes = Util.ByteSubString(src, 0, i);
        this.NickStr = Util.fromJIS(this.NickBytes);
        this.AfterNickBytes = Util.ByteSubString(src, i, src.length);
        this.AfterNickStr = Util.fromJIS(this.AfterNickBytes);
        this.PrefixStr = this.NickStr + this.AfterNickStr;
    }

    public void changeNick(byte[] src) {
        int i = Util.ByteIndexOf(src, '!');
        if (i == -1) {
            i = src.length;
        }
        this.NickBytes = Util.ByteSubString(src, 0, i);
        this.NickStr = Util.fromJIS(this.NickBytes);
        this.PrefixStr = this.NickStr + this.AfterNickStr;
    }

    public static final int tolower(int src) {
        if (src >= 65 && src <= 90) {
            return src + 32;
        }
        int i = "[]\\".indexOf((char)src);
        if (i == -1) {
            return src;
        }
        return "{}|".charAt(i);
    }

    public final int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 instanceof IRCChannelMember) {
            o1 = ((IRCChannelMember)o1).getUser();
        }
        if (o2 instanceof IRCChannelMember) {
            o2 = ((IRCChannelMember)o2).getUser();
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 instanceof IRCUser) {
            o1 = ((IRCUser)o1).NickBytes;
        }
        if (o2 instanceof IRCUser) {
            o2 = ((IRCUser)o2).NickBytes;
        }
        if (o1 == o2) {
            return 0;
        }
        byte[] a = (byte[])o1;
        byte[] b = (byte[])o2;
        if (a == b) {
            return 0;
        }
        int minlength = a.length < b.length ? a.length : b.length;
        int i = 0;
        while (i < minlength) {
            int r = IRCUser.tolower(a[i]) - IRCUser.tolower(b[i]);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return a.length - b.length;
    }

    public final int compareTo(Object b) {
        return this.compare(this, b);
    }

    public final boolean equals(Object b) {
        return 0 == this.compare(this, b);
    }

    public String getServer() {
        return this.Server;
    }

    public String getHomeGone() {
        return this.HomeGone;
    }

    public int getHopCount() {
        return this.HopCount;
    }

    public String getRealName() {
        return this.RealName;
    }

    void setWhoReply(byte[] server, int hopcount, String RealName, byte[] baHomeGone) {
        this.Server = Util.RecycleString(Util.fromJIS(server));
        this.HopCount = hopcount;
        this.RealName = RealName;
        this.HomeGone = baHomeGone.length != 0 ? Util.RecycleString("" + (char)baHomeGone[0]) : null;
    }

    public int updatePrefix(byte[] new_AfterNickBytes, int start) {
        int r = 1;
        if (this.AfterNickBytes.length != 0) {
            if (0 == Util.compareByteArray(this.AfterNickBytes, 0, new_AfterNickBytes, start)) {
                return 0;
            }
            this.Server = null;
            this.RealName = null;
            this.HopCount = -2;
            this.HomeGone = null;
            r = 2;
        }
        this.AfterNickBytes = Util.ByteSubString(new_AfterNickBytes, start, new_AfterNickBytes.length);
        this.AfterNickStr = Util.fromJIS(this.AfterNickBytes);
        this.PrefixStr = this.NickStr + this.AfterNickStr;
        return r;
    }
}

