/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui.resource;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceFormatException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle rb, ActionMap am) {
        super(rb);
        this.actions = am;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar result = new JMenuBar();
        List menus = this.getStringList(name);
        Iterator it = menus.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next()));
        }
        return result;
    }

    protected JComponent createJMenuComponent(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (name.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String type = this.getString(name + TYPE_SUFFIX);
        JMenuItem item = null;
        if (type.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (type.equals(TYPE_MENU)) {
            item = this.createJMenu(name);
        } else if (type.equals(TYPE_ITEM)) {
            item = this.createJMenuItem(name);
        } else if (type.equals(TYPE_RADIO)) {
            item = this.createJRadioButtonMenuItem(name);
            this.buttonGroup.add(item);
        } else if (type.equals(TYPE_CHECK)) {
            item = this.createJCheckBoxMenuItem(name);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), name + TYPE_SUFFIX);
        }
        return item;
    }

    public JMenu createJMenu(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu result = new JMenu(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        List items = this.getStringList(name);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next()));
        }
        return result;
    }

    public JMenuItem createJMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem result = new JMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        return result;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        try {
            result.setSelected(this.getBoolean(name + SELECTED_SUFFIX));
        }
        catch (MissingResourceException e) {}
        return result;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(this.getString(name + TEXT_SUFFIX));
        this.initializeJMenuItem(result, name);
        try {
            result.setSelected(this.getBoolean(name + SELECTED_SUFFIX));
        }
        catch (MissingResourceException e) {}
        return result;
    }

    private void initializeJMenuItem(JMenuItem item, String name) throws ResourceFormatException, MissingListenerException {
        block13: {
            String str;
            try {
                String s = this.getString(name + ICON_SUFFIX);
                URL url = this.actions.getClass().getResource(s);
                if (url != null) {
                    item.setIcon(new ImageIcon(url));
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                str = this.getString(name + MNEMONIC_SUFFIX);
                if (str.length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), name + MNEMONIC_SUFFIX);
                }
                item.setMnemonic(str.charAt(0));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                if (item instanceof JMenu) break block13;
                str = this.getString(name + ACCELERATOR_SUFFIX);
                KeyStroke ks = this.toKeyStroke(str);
                if (ks != null) {
                    item.setAccelerator(ks);
                    break block13;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), name + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            Action a = this.actions.getAction(this.getString(name + ACTION_SUFFIX));
            if (a == null) {
                throw new MissingListenerException("", "Action", name + ACTION_SUFFIX);
            }
            item.addActionListener(a);
            if (a instanceof JComponentModifier) {
                ((JComponentModifier)((Object)a)).addJComponent(item);
            }
        }
        catch (MissingResourceException e) {}
    }

    protected KeyStroke toKeyStroke(String str) {
        int state = 0;
        int code = 0;
        int modif = 0;
        int i = 0;
        while (state != 100 && i < str.length()) {
            char curr = Character.toUpperCase(str.charAt(i));
            block0 : switch (state) {
                case 0: {
                    code = curr;
                    switch (curr) {
                        case 'C': {
                            state = 1;
                            break block0;
                        }
                        case 'A': {
                            state = 5;
                            break block0;
                        }
                        case 'M': {
                            state = 8;
                            break block0;
                        }
                        case 'S': {
                            state = 12;
                            break block0;
                        }
                    }
                    state = 100;
                    break;
                }
                case 1: {
                    state = curr == 'T' ? 2 : 100;
                    break;
                }
                case 2: {
                    state = curr == 'R' ? 3 : 100;
                    break;
                }
                case 3: {
                    state = curr == 'L' ? 4 : 100;
                    break;
                }
                case 4: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) break;
                    modif |= 2;
                    break;
                }
                case 5: {
                    state = curr == 'L' ? 6 : 100;
                    break;
                }
                case 6: {
                    state = curr == 'T' ? 7 : 100;
                    break;
                }
                case 7: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) break;
                    modif |= 8;
                    break;
                }
                case 8: {
                    state = curr == 'E' ? 9 : 100;
                    break;
                }
                case 9: {
                    state = curr == 'T' ? 10 : 100;
                    break;
                }
                case 10: {
                    state = curr == 'A' ? 11 : 100;
                    break;
                }
                case 11: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) break;
                    modif |= 4;
                    break;
                }
                case 12: {
                    state = curr == 'H' ? 13 : 100;
                    break;
                }
                case 13: {
                    state = curr == 'I' ? 14 : 100;
                    break;
                }
                case 14: {
                    state = curr == 'F' ? 15 : 100;
                    break;
                }
                case 15: {
                    state = curr == 'T' ? 16 : 100;
                    break;
                }
                case 16: {
                    int n = state = curr == '+' ? 0 : 100;
                    if (state != 0) break;
                    modif |= 1;
                }
            }
            ++i;
        }
        if (code > 0 && modif > 0) {
            return KeyStroke.getKeyStroke(code, modif);
        }
        return null;
    }
}

