/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeChecker;
import koala.dynamicjava.interpreter.UninitializedObject;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.throwable.BreakException;
import koala.dynamicjava.interpreter.throwable.ContinueException;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;
import koala.dynamicjava.util.ImportationManager;

public class EvaluationVisitor
extends VisitorObject {
    private Context context;
    static /* synthetic */ Class class$java$lang$Character;

    public EvaluationVisitor(Context ctx) {
        this.context = ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(WhileStatement node) {
        while (true) {
            try {
                if (!((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) return null;
                try {
                    node.getBody().acceptVisitor(this);
                    continue;
                }
                catch (ContinueException e) {
                    if (e.isLabeled() && !node.hasLabel(e.getLabel())) throw e;
                    continue;
                }
            }
            catch (BreakException e) {
                if (!e.isLabeled() || node.hasLabel(e.getLabel())) return null;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ForStatement node) {
        try {
            block11: {
                Set vars = (Set)node.getProperty("variables");
                this.context.enterScope(vars);
                if (node.getInitialization() != null) {
                    Iterator it = node.getInitialization().iterator();
                    while (it.hasNext()) {
                        ((Node)it.next()).acceptVisitor(this);
                    }
                }
                try {
                    Expression cond = node.getCondition();
                    List update = node.getUpdate();
                    while (cond == null || ((Boolean)cond.acceptVisitor(this)).booleanValue()) {
                        block10: {
                            try {
                                node.getBody().acceptVisitor(this);
                            }
                            catch (ContinueException e) {
                                if (!e.isLabeled() || node.hasLabel(e.getLabel())) break block10;
                                throw e;
                            }
                        }
                        if (update == null) continue;
                        Iterator it = update.iterator();
                        while (it.hasNext()) {
                            ((Node)it.next()).acceptVisitor(this);
                        }
                    }
                }
                catch (BreakException e) {
                    if (!e.isLabeled() || node.hasLabel(e.getLabel())) break block11;
                    throw e;
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.context.leaveScope();
            throw throwable;
        }
        this.context.leaveScope();
        return null;
    }

    public Object visit(DoStatement node) {
        block5: {
            try {
                do {
                    try {
                        node.getBody().acceptVisitor(this);
                    }
                    catch (ContinueException e) {
                        if (!e.isLabeled() || node.hasLabel(e.getLabel())) continue;
                        throw e;
                    }
                } while (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue());
            }
            catch (BreakException e) {
                if (!e.isLabeled() || node.hasLabel(e.getLabel())) break block5;
                throw e;
            }
        }
        return null;
    }

    public Object visit(SwitchStatement node) {
        block15: {
            try {
                SwitchBlock sc;
                boolean processed = false;
                Object o = node.getSelector().acceptVisitor(this);
                if (o instanceof Character) {
                    o = new Integer(((Character)o).charValue());
                }
                Number n = (Number)o;
                ListIterator it = node.getBindings().listIterator();
                ListIterator dit = null;
                block2: while (it.hasNext()) {
                    sc = (SwitchBlock)it.next();
                    Number l = null;
                    if (sc.getExpression() != null) {
                        o = sc.getExpression().acceptVisitor(this);
                        if (o instanceof Character) {
                            o = new Integer(((Character)o).charValue());
                        }
                        l = (Number)o;
                    } else {
                        dit = node.getBindings().listIterator(it.nextIndex() - 1);
                    }
                    if (l == null || n.intValue() != l.intValue()) continue;
                    processed = true;
                    while (true) {
                        if (sc.getStatements() != null) {
                            Iterator it2 = sc.getStatements().iterator();
                            while (it2.hasNext()) {
                                ((Node)it2.next()).acceptVisitor(this);
                            }
                        }
                        if (!it.hasNext()) break block2;
                        sc = (SwitchBlock)it.next();
                    }
                }
                if (!processed && dit != null) {
                    sc = (SwitchBlock)dit.next();
                    while (true) {
                        if (sc.getStatements() != null) {
                            Iterator it2 = sc.getStatements().iterator();
                            while (it2.hasNext()) {
                                ((Node)it2.next()).acceptVisitor(this);
                            }
                        }
                        if (dit.hasNext()) {
                            sc = (SwitchBlock)dit.next();
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (BreakException e) {
                if (!e.isLabeled()) break block15;
                throw e;
            }
        }
        return null;
    }

    public Object visit(LabeledStatement node) {
        block2: {
            try {
                node.getStatement().acceptVisitor(this);
            }
            catch (BreakException e) {
                if (e.isLabeled() && e.getLabel().equals(node.getLabel())) break block2;
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(SynchronizedStatement node) {
        Object object = node.getLock().acceptVisitor(this);
        synchronized (object) {
            node.getBody().acceptVisitor(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(BreakStatement node) {
        BreakException ex = (BreakException)node.getProperty("breakException");
        if (ex == null) {
            BreakStatement breakStatement = node;
            synchronized (breakStatement) {
                ex = (BreakException)node.getProperty("breakException");
                if (ex == null) {
                    ex = new BreakException("unexpected.break", node.getLabel());
                    node.setProperty("breakException", ex);
                }
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ContinueStatement node) {
        ContinueException ex = (ContinueException)node.getProperty("continueException");
        if (ex == null) {
            ContinueStatement continueStatement = node;
            synchronized (continueStatement) {
                ex = (ContinueException)node.getProperty("continueException");
                if (ex == null) {
                    ex = new ContinueException("unexpected.continue", node.getLabel());
                    node.setProperty("continueException", ex);
                }
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(TryStatement node) {
        Node n;
        block15: {
            boolean handled = false;
            try {
                node.getTryBlock().acceptVisitor(this);
                if (!handled) break block15;
            }
            catch (Throwable e) {
                try {
                    Throwable t = e;
                    if (e instanceof ThrownException) {
                        t = ((ThrownException)e).getException();
                    } else if (e instanceof CatchedExceptionError) {
                        t = ((CatchedExceptionError)e).getException();
                    }
                    Iterator it = node.getCatchStatements().iterator();
                    while (it.hasNext()) {
                        CatchStatement cs = (CatchStatement)it.next();
                        Class c = NodeProperties.getType(cs.getException().getType());
                        if (!c.isAssignableFrom(t.getClass())) continue;
                        handled = true;
                        this.context.enterScope();
                        this.context.define(cs.getException().getName(), t);
                        cs.getBlock().acceptVisitor(this);
                        break;
                    }
                    if (!handled) {
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new CatchedExceptionError((Exception)e, (Node)node);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Node n2;
                    if (handled) {
                        this.context.leaveScope();
                    }
                    if ((n2 = node.getFinallyBlock()) != null) {
                        n2.acceptVisitor(this);
                    }
                }
            }
            this.context.leaveScope();
        }
        if ((n = node.getFinallyBlock()) != null) {
            n.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(ThrowStatement node) {
        throw new ThrownException((Throwable)node.getExpression().acceptVisitor(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ReturnStatement node) {
        ReturnException ex;
        ThreadLocal<ReturnException> tl = (ThreadLocal<ReturnException>)node.getProperty("returnThreadLocal");
        if (tl == null) {
            ReturnStatement returnStatement = node;
            synchronized (returnStatement) {
                tl = (ThreadLocal)node.getProperty("returnThreadLocal");
                if (tl == null) {
                    tl = new ThreadLocal<ReturnException>();
                    node.setProperty("returnThreadLocal", tl);
                }
            }
        }
        if ((ex = (ReturnException)tl.get()) == null) {
            ReturnStatement returnStatement = node;
            synchronized (returnStatement) {
                ex = (ReturnException)tl.get();
                if (ex == null) {
                    ex = new ReturnException("return.statement", node);
                    tl.set(ex);
                }
            }
        }
        if (node.getExpression() != null) {
            ex.setValue(true, node.getExpression().acceptVisitor(this));
        } else {
            ex.setValue(false, null);
        }
        throw ex;
    }

    public Object visit(IfThenStatement node) {
        if (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        }
        return null;
    }

    public Object visit(IfThenElseStatement node) {
        if (((Boolean)node.getCondition().acceptVisitor(this)).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        } else {
            node.getElseStatement().acceptVisitor(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(BlockStatement node) {
        try {
            Set vars = (Set)node.getProperty("variables");
            this.context.enterScope(vars);
            Iterator it = node.getStatements().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.context.leaveScope();
            throw throwable;
        }
        this.context.leaveScope();
        return null;
    }

    public Object visit(Literal node) {
        return node.getValue();
    }

    public Object visit(VariableDeclaration node) {
        Class c = NodeProperties.getType(node.getType());
        if (node.getInitializer() != null) {
            Object o = EvaluationVisitor.performCast(c, node.getInitializer().acceptVisitor(this));
            if (node.isFinal()) {
                this.context.setConstant(node.getName(), o);
            } else {
                this.context.set(node.getName(), o);
            }
        } else if (node.isFinal()) {
            this.context.setConstant(node.getName(), UninitializedObject.INSTANCE);
        } else {
            this.context.set(node.getName(), UninitializedObject.INSTANCE);
        }
        return null;
    }

    public Object visit(ObjectFieldAccess node) {
        Class c = NodeProperties.getType(node.getExpression());
        Object obj = node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            Field f = (Field)node.getProperty("field");
            if (this.context.getAccessible()) {
                f.setAccessible(true);
            }
            try {
                return f.get(obj);
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return new Integer(Array.getLength(obj));
    }

    public Object visit(ObjectMethodCall node) {
        Expression exp = node.getExpression();
        Object obj = exp.acceptVisitor(this);
        if (node.hasProperty("method")) {
            Method m = (Method)node.getProperty("method");
            Class<?>[] typs = m.getParameterTypes();
            if (this.context.getAccessible()) {
                m.setAccessible(true);
            }
            List larg = node.getArguments();
            Object[] args = Constants.EMPTY_OBJECT_ARRAY;
            if (larg != null) {
                args = new Object[larg.size()];
                Iterator it = larg.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object p = ((Expression)it.next()).acceptVisitor(this);
                    args[i] = EvaluationVisitor.performCast(typs[i], p);
                    ++i;
                }
            }
            try {
                return m.invoke(obj, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                System.err.println("invoke failed 1:" + cause + " " + cause.getMessage());
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new ThrownException(cause, (Node)node);
            }
            catch (Exception e) {
                System.err.println("invoke failed 2:" + e.toString() + " " + e.getMessage());
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        Class c = NodeProperties.getType(exp);
        int len = Array.getLength(obj);
        Object result = Array.newInstance(c.getComponentType(), len);
        int i = 0;
        while (i < len) {
            Array.set(result, i, Array.get(obj, i));
            ++i;
        }
        return result;
    }

    public Object visit(StaticFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        try {
            return f.get(null);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object visit(SuperFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        try {
            return f.get(this.context.getHiddenArgument());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object visit(SuperMethodCall node) {
        Method m = (Method)node.getProperty("method");
        List larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        if (larg != null) {
            Iterator it = larg.iterator();
            int i = 0;
            args = new Object[larg.size()];
            while (it.hasNext()) {
                args[i] = ((Expression)it.next()).acceptVisitor(this);
                ++i;
            }
        }
        try {
            return m.invoke(this.context.getHiddenArgument(), args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object visit(StaticMethodCall node) {
        Method m = (Method)node.getProperty("method");
        List larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        if (larg != null) {
            args = new Object[larg.size()];
            Iterator it = larg.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i] = ((Expression)it.next()).acceptVisitor(this);
                ++i;
            }
        }
        try {
            return m.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object visit(SimpleAssignExpression node) {
        Expression ln = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(ln);
        mod.prepare(this, this.context);
        Object val = node.getRightExpression().acceptVisitor(this);
        val = EvaluationVisitor.performCast(NodeProperties.getType(node), val);
        mod.modify(this.context, val);
        return val;
    }

    public Object visit(QualifiedName node) {
        Object result = this.context.get(node.getRepresentation());
        if (result == UninitializedObject.INSTANCE) {
            node.setProperty("errorStrings", new String[]{node.getRepresentation()});
            throw new ExecutionError("uninitialized.variable", node);
        }
        return result;
    }

    public Object visit(TypeExpression node) {
        return node.getProperty("value");
    }

    public Object visit(SimpleAllocation node) {
        List larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        if (larg != null) {
            args = new Object[larg.size()];
            Iterator it = larg.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i++] = ((Expression)it.next()).acceptVisitor(this);
            }
        }
        return this.context.invokeConstructor(node, args);
    }

    public Object visit(ArrayAllocation node) {
        if (node.getInitialization() != null) {
            return node.getInitialization().acceptVisitor(this);
        }
        int[] dims = new int[node.getSizes().size()];
        Iterator it = node.getSizes().iterator();
        int i = 0;
        while (it.hasNext()) {
            Number n = (Number)((Expression)it.next()).acceptVisitor(this);
            dims[i++] = n.intValue();
        }
        if (node.getDimension() != dims.length) {
            Class<?> c = NodeProperties.getComponentType(node);
            c = Array.newInstance(c, 0).getClass();
            return Array.newInstance(c, dims);
        }
        return Array.newInstance(NodeProperties.getComponentType(node), dims);
    }

    public Object visit(ArrayInitializer node) {
        Object result = Array.newInstance(NodeProperties.getType(node.getElementType()), node.getCells().size());
        Iterator it = node.getCells().iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = ((Expression)it.next()).acceptVisitor(this);
            Array.set(result, i++, o);
        }
        return result;
    }

    public Object visit(ArrayAccess node) {
        Object t = node.getExpression().acceptVisitor(this);
        Object o = node.getCellNumber().acceptVisitor(this);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        return Array.get(t, ((Number)o).intValue());
    }

    public Object visit(InnerAllocation node) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        Class c = NodeProperties.getType(node);
        List larg = node.getArguments();
        Object[] args = null;
        if (larg != null) {
            args = new Object[larg.size() + 1];
            args[0] = node.getExpression().acceptVisitor(this);
            Iterator it = larg.iterator();
            int i = 1;
            while (it.hasNext()) {
                args[i++] = ((Expression)it.next()).acceptVisitor(this);
            }
        } else {
            args = new Object[]{node.getExpression().acceptVisitor(this)};
        }
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object visit(ClassAllocation node) {
        List larg = node.getArguments();
        Object[] args = Constants.EMPTY_OBJECT_ARRAY;
        if (larg != null) {
            args = new Object[larg.size()];
            Iterator it = larg.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i++] = ((Expression)it.next()).acceptVisitor(this);
            }
        }
        return this.context.invokeConstructor(node, args);
    }

    public Object visit(NotExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Boolean b = (Boolean)node.getExpression().acceptVisitor(this);
        if (b.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(ComplementExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Class c = NodeProperties.getType(node);
        Object o = node.getExpression().acceptVisitor(this);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(~((Number)o).intValue());
        }
        return new Long(((Number)o).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object visit(PlusExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.plus(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    public Object visit(MinusExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.minus(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    public Object visit(AddExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.add(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(AddAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.add(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(SubtractExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.subtract(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(SubtractAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.subtract(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(MultiplyExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.multiply(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(MultiplyAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.multiply(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(DivideExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.divide(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(DivideAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.divide(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(RemainderExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.remainder(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(RemainderAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.remainder(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(EqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.equalTo(NodeProperties.getType(ln), NodeProperties.getType(rn), ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(NotEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.notEqualTo(NodeProperties.getType(ln), NodeProperties.getType(rn), ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(LessExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.lessThan(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(LessOrEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.lessOrEqual(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(GreaterExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.greaterThan(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(GreaterOrEqualExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        return InterpreterUtilities.greaterOrEqual(ln.acceptVisitor(this), rn.acceptVisitor(this));
    }

    public Object visit(InstanceOfExpression node) {
        Object v = node.getExpression().acceptVisitor(this);
        Class c = NodeProperties.getType(node.getReferenceType());
        return c.isInstance(v) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visit(ConditionalExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        Boolean b = (Boolean)node.getConditionExpression().acceptVisitor(this);
        if (b.booleanValue()) {
            return node.getIfTrueExpression().acceptVisitor(this);
        }
        return node.getIfFalseExpression().acceptVisitor(this);
    }

    public Object visit(PostIncrement node) {
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        mod.modify(this.context, InterpreterUtilities.add(NodeProperties.getType(node), v, InterpreterUtilities.ONE));
        return v;
    }

    public Object visit(PreIncrement node) {
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        v = InterpreterUtilities.add(NodeProperties.getType(node), v, InterpreterUtilities.ONE);
        mod.modify(this.context, v);
        return v;
    }

    public Object visit(PostDecrement node) {
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        mod.modify(this.context, InterpreterUtilities.subtract(NodeProperties.getType(node), v, InterpreterUtilities.ONE));
        return v;
    }

    public Object visit(PreDecrement node) {
        Expression exp = node.getExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(exp);
        Object v = mod.prepare(this, this.context);
        v = InterpreterUtilities.subtract(NodeProperties.getType(node), v, InterpreterUtilities.ONE);
        mod.modify(this.context, v);
        return v;
    }

    public Object visit(CastExpression node) {
        return EvaluationVisitor.performCast(NodeProperties.getType(node), node.getExpression().acceptVisitor(this));
    }

    public Object visit(BitAndExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.bitAnd(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(BitAndAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.bitAnd(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        NodeProperties.getModifier(left).modify(this.context, result);
        return result;
    }

    public Object visit(ExclusiveOrExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.xOr(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ExclusiveOrAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.xOr(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(BitOrExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.bitOr(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(BitOrAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.bitOr(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(ShiftLeftExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.shiftLeft(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ShiftLeftAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.shiftLeft(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(ShiftRightExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.shiftRight(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ShiftRightAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.shiftRight(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(UnsignedShiftRightExpression node) {
        if (node.hasProperty("value")) {
            return node.getProperty("value");
        }
        return InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(node), node.getLeftExpression().acceptVisitor(this), node.getRightExpression().acceptVisitor(this));
    }

    public Object visit(UnsignedShiftRightAssignExpression node) {
        Expression left = node.getLeftExpression();
        LeftHandSideModifier mod = NodeProperties.getModifier(left);
        Object lhs = mod.prepare(this, this.context);
        Object result = InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(node), lhs, node.getRightExpression().acceptVisitor(this));
        result = EvaluationVisitor.performCast(NodeProperties.getType(left), result);
        mod.modify(this.context, result);
        return result;
    }

    public Object visit(AndExpression node) {
        Expression exp = node.getLeftExpression();
        boolean b = (Boolean)exp.acceptVisitor(this);
        if (b) {
            exp = node.getRightExpression();
            b = (Boolean)exp.acceptVisitor(this);
            return b ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(OrExpression node) {
        Expression exp = node.getLeftExpression();
        boolean b = (Boolean)exp.acceptVisitor(this);
        if (!b) {
            exp = node.getRightExpression();
            b = (Boolean)exp.acceptVisitor(this);
            return b ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(FunctionCall node) {
        BlockStatement body;
        MethodDeclaration md = (MethodDeclaration)node.getProperty("function");
        GlobalContext c = new GlobalContext(this.context.getInterpreter());
        if (node.getArguments() != null) {
            Iterator it = md.getParameters().iterator();
            Iterator it2 = node.getArguments().iterator();
            while (it.hasNext()) {
                FormalParameter fp = (FormalParameter)it.next();
                if (fp.isFinal()) {
                    c.setConstant(fp.getName(), ((Node)it2.next()).acceptVisitor(this));
                    continue;
                }
                c.setVariable(fp.getName(), ((Node)it2.next()).acceptVisitor(this));
            }
        }
        if (!(body = md.getBody()).hasProperty("visited")) {
            body.setProperty("visited", null);
            ImportationManager im = (ImportationManager)md.getProperty("importationManager");
            GlobalContext ctx = new GlobalContext(this.context.getInterpreter());
            ctx.setImportationManager(im);
            VisitorObject v = new NameVisitor(ctx);
            Iterator it = md.getParameters().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(v);
            }
            ((Node)body).acceptVisitor(v);
            ctx = new GlobalContext(this.context.getInterpreter());
            ctx.setImportationManager(im);
            ctx.setFunctions((List)md.getProperty("functions"));
            v = new TypeChecker(ctx);
            it = md.getParameters().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(v);
            }
            ((Node)body).acceptVisitor(v);
        }
        try {
            ((Node)body).acceptVisitor(new EvaluationVisitor(c));
        }
        catch (ReturnException e) {
            return e.getValue();
        }
        return null;
    }

    protected static Object performCast(Class tc, Object o) {
        Class<?> ec;
        Class<?> clazz = ec = o != null ? o.getClass() : null;
        if (tc != ec && tc.isPrimitive() && ec != null) {
            if (tc != Character.TYPE && ec == (class$java$lang$Character == null ? (class$java$lang$Character = EvaluationVisitor.class$("java.lang.Character")) : class$java$lang$Character)) {
                o = new Integer(((Character)o).charValue());
            } else if (tc == Byte.TYPE) {
                o = new Byte(((Number)o).byteValue());
            } else if (tc == Short.TYPE) {
                o = new Short(((Number)o).shortValue());
            } else if (tc == Integer.TYPE) {
                o = new Integer(((Number)o).intValue());
            } else if (tc == Long.TYPE) {
                o = new Long(((Number)o).longValue());
            } else if (tc == Float.TYPE) {
                o = new Float(((Number)o).floatValue());
            } else if (tc == Double.TYPE) {
                o = new Double(((Number)o).doubleValue());
            } else if (tc == Character.TYPE && ec != (class$java$lang$Character == null ? (class$java$lang$Character = EvaluationVisitor.class$("java.lang.Character")) : class$java$lang$Character)) {
                o = new Character((char)((Number)o).shortValue());
            }
        }
        return o;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

